% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/corpus.R
\name{ntoken}
\alias{ntoken}
\alias{ntoken.character}
\alias{ntoken.corpus}
\alias{ntoken.dfm}
\alias{ntoken.tokenizedTexts}
\alias{ntype}
\alias{ntype.character}
\alias{ntype.corpus}
\alias{ntype.dfm}
\alias{ntype.tokenizedTexts}
\title{count the number of tokens or types}
\usage{
ntoken(x, ...)

ntype(x, ...)

\method{ntoken}{corpus}(x, ...)

\method{ntype}{corpus}(x, ...)

\method{ntoken}{character}(x, ...)

\method{ntoken}{tokenizedTexts}(x, ...)

\method{ntype}{character}(x, ...)

\method{ntoken}{dfm}(x, ...)

\method{ntype}{dfm}(x, ...)

\method{ntype}{tokenizedTexts}(x, ...)
}
\arguments{
\item{x}{texts or corpus whose tokens or types will be counted}

\item{...}{additional arguments passed to \code{\link{tokenize}}}
}
\value{
scalar count of the total tokens or types
}
\description{
Return the count of tokens (total features) or types (unique features) in a
text, corpus, or dfm.  "tokens" here means all words, not unique words, and
these are not cleaned prior to counting.
}
\note{
Due to differences between raw text tokens and features that have been
  defined for a \link{dfm}, the counts be different for dfm objects and the
  texts from which the dfm was generated.  Because the method tokenizes the
  text in order to count the tokens, your results will depend on the options
  passed through to \code{\link{tokenize}}
}
\examples{
# simple example
txt <- c(text1 = "This is a sentence, this.", text2 = "A word. Repeated repeated.")
ntoken(txt)
ntype(txt)
ntoken(toLower(txt))  # same
ntype(toLower(txt))   # fewer types
ntoken(toLower(txt), removePunct = TRUE)
ntype(toLower(txt), removePunct = TRUE)

# with some real texts
ntoken(subset(inaugCorpus, Year<1806, removePunct = TRUE))
ntype(subset(inaugCorpus, Year<1806, removePunct = TRUE))
ntoken(dfm(subset(inaugCorpus, Year<1800)))
ntype(dfm(subset(inaugCorpus, Year<1800)))
}

