#' One sample single sided t-test on matrix
#' @param ddtas - matrix
#' @param adjust - should p-values be adjusted
#' @export
#' @examples
#'
#' data <- matrix(rnorm(100,1,1), ncol=5)
#' dim(data)
#' rownames(data) <- 1:20
#' onesamplegreaterT(data)
#' 
onesamplegreaterT <- function(ddtas,adjust=TRUE){
  p.vals <-apply(ddtas, 1, function(x){ t.test(x,alternative = "greater")$p.value })
  p.vals[is.na(p.vals)]<-1
  if(adjust){
    p.vals<-p.adjust(p.vals,method = "BH")
  }
  fc <- apply(ddtas,1,mean)
  return(data.frame(names=rownames(ddtas),pval=p.vals, fchange=fc))
}
#' Plot and filter data coming from one sample single sided t-test
#' @param data - matrix generated by onesamplegreaterT
#' @param p.thresh - p value to filter with, default 0.05
#' @param fc.thresh - fold change threshold to filter with, default 2
#' @param main - main title of plot
#' @export
#' @examples
#'
#' data <- matrix(rnorm(100,1,1), ncol=5)
#' dim(data)
#' rownames(data) <- 1:20
#' resM <- onesamplegreaterT(data)
#' plotOneSideVolcano(resM)
#' data <- matrix(rnorm(100,2,1), ncol=5)
#' dim(data)
#' rownames(data) <- 1:20
#' resM <- onesamplegreaterT(data)
#' plotOneSideVolcano(resM)
plotOneSideVolcano <- function(data,  p.thresh = 0.05, fc.thresh=2 ,main=""){
  p.vals <- data$pval
  fc <- data$fchange
  labels <- as.character(data$names)
  plot(fc,-log10(p.vals), main=main)
  
  abline(h=-log10(p.thresh),col=2)
  abline(v=c(0))
  abline(v=fc.thresh,col=2)
  idx <- p.vals <= p.thresh & fc >= fc.thresh
  if(sum(idx)>0){
    text(fc[idx],-log10(p.vals[idx]),labels = labels[idx], pos=2,cex=0.5)
    points(fc[idx],-log10(p.vals[idx]),col=2,pch=19)
    return(data[idx,])
  }else{
    return(NULL)
  }
}
