% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/symmetricPolynomials.R
\name{MSPcombination}
\alias{MSPcombination}
\title{Symmetric polynomial in terms of the monomial symmetric polynomials}
\usage{
MSPcombination(qspray, check = TRUE)
}
\arguments{
\item{qspray}{a \code{qspray} object defining a symmetric polynomial}

\item{check}{Boolean, whether to check the symmetry}
}
\value{
A list defining the combination. Each element of this list is a 
  list with two elements: \code{coeff}, a \code{bigq} number, and 
  \code{lambda}, an integer partition; then this list corresponds to the 
  term \code{coeff * MSFpoly(n, lambda)}, where \code{n} is the number of 
  variables in the symmetric polynomial.
}
\description{
Expression of a symmetric polynomial as a linear combination 
  of the monomial symmetric polynomials.
}
\examples{
qspray <- PSFpoly(4, c(3, 1)) + ESFpoly(4, c(2, 2)) + 4L
MSPcombination(qspray)
}
