
test_that("Field plot label PDF successful generation", {
  #skip_on_cran()
  
  path <- tempdir()
  setwd(path)
  
  expect_invisible(
    field_label(dat = data.frame(LOCATION = rep("BAMBEY", 10), 
                                PLOT = 1001:1010, 
                                ROW = c(rep(1, 6), rep(2, 4)),
                                COLUMN = c(1:6, 1:4),
                                REP = rep(1, 10),
                                IBLOCK = c(rep(1, 6), rep(2, 4)),
                                TREATMENT = paste0("G-", 1:10),
                                SEED_SOURCE = rep("OFF_NUR", 10)),
                                wdt = 5, 
                                hgt = 2,
                                page_wdt = 8.5, 
                                page_hgt = 11,
                                top_mar = 0.75, 
                                bot_mar = 0.75, 
                                left_mar = 1.75, 
                                right_mar = 1.75, 
                                numrow = 4L, 
                                numcol = 1L, 
                                filename = "PlotLabel", 
                                font_sz = 20, 
                                Trial = 'PYT', 
                                Year = 2023, 
                                family = 'sans', 
                                rounded = TRUE, 
                                IBlock = TRUE,
                                get_unique_id = "ruid", 
                                rname = "AW Kena", 
                                rep_id = 'REP',
                                plot_id = 'PLOT',
                                row_id = 'ROW', 
                                col_id = 'COLUMN', 
                                loc_id = 'LOCATION',
                                entry_id = 'TREATMENT', 
                                IBlock_id = 'IBLOCK', 
                                seed_source = TRUE, 
                                seed_source_id = "SEED_SOURCE" ))
  
  expect_true(length(list.files(path = ".", pattern = "\\.pdf$")) > 0)
  expect_true(length(list.files(path = ".", pattern = "\\.csv$")) > 0)
  
  on.exit(unlink(path))
  })

test_that("Field plot label input errors", {
  #skip_on_cran()
  
  expect_error(field_label(font_sz = 10,
                           IBlock = FALSE,
                           get_unique_id = "ruid",
                           rname = "AWK",
                           family = "sans",
                           seed_source = FALSE ), 
               "Fieldbook is missing, please provide a fieldbook as a data frame.")
  
  
  expect_error(field_label(dat = data.frame(LOCATION = rep("BAMBEY", 10), 
                                            PLOT = 1001:1010, 
                                            ROW = c(rep(1, 6), rep(2, 4)),
                                            COLUMN = c(1:6, 1:4),
                                            REP = rep(1, 10),
                                            IBLOCK = c(rep(1, 6), rep(2, 4)),
                                            TREATMENT = paste0("G-", 1:10),
                                            SEED_SOURCE = rep("OFF_NUR", 10)),
                                             wdt = 5, 
                                             hgt = 2,
                                             top_mar = 2, 
                                             bot_mar = 2, 
                                             left_mar = 4, 
                                             right_mar = 4, 
                                             numrow = 4L, 
                                             numcol = 1L, 
                                             filename = "PlotLabel", 
                                             font_sz = 20, 
                                             get_unique_id = "ruid", 
                                             rname = "AW Kena", 
                                             seed_source = TRUE, 
                                             seed_source_id = "SEED_SOURCE" ), 
               "Page setup does not match label setup per page.")
  
  
  
  expect_error(field_label(dat = data.frame(LOCATION = rep("BAMBEY", 10), 
                                            PLOT = 1001:1010, 
                                            ROW = c(rep(1, 6), rep(2, 4)),
                                            COLUMN = c(1:6, 1:4),
                                            REP = rep(1, 10),
                                            IBLOCK = c(rep(1, 6), rep(2, 4)),
                                            TREATMENT = paste0("G-", 1:10),
                                            SEED_SOURCE = rep("OFF_NUR", 10)),
                           
                                             rep_id = 1,
                                             plot_id = 'PLOT',
                                             row_id = 'ROW', 
                                             col_id = 'COLUMN', 
                                             loc_id = 'LOCATION',
                                             entry_id = 'TREATMENT', 
                                             IBlock_id = 'IBLOCK', 
                                             get_unique_id = "ruid", 
                                             rname = "AW Kena", 
                                             seed_source = TRUE, 
                                             seed_source_id = "SEED_SOURCE" ),
               "'rep_id' must be string value.")
  
  expect_error(field_label(dat = data.frame(LOCATION = rep("BAMBEY", 10), 
                                            PLOT = 1001:1010, 
                                            ROW = c(rep(1, 6), rep(2, 4)),
                                            COLUMN = c(1:6, 1:4),
                                            REP = rep(1, 10),
                                            IBLOCK = c(rep(1, 6), rep(2, 4)),
                                            TREATMENT = paste0("G-", 1:10),
                                            SEED_SOURCE = rep("OFF_NUR", 10)),
                           
                                             rep_id = 'REP',
                                             plot_id = 1,
                                             row_id = 'ROW', 
                                             col_id = 'COLUMN', 
                                             loc_id = 'LOCATION',
                                             entry_id = 'TREATMENT', 
                                             IBlock_id = 'IBLOCK', 
                                             get_unique_id = "ruid", 
                                             rname = "AW Kena", 
                                             seed_source = TRUE, 
                                             seed_source_id = "SEED_SOURCE" ),
               "'plot_id' must be string value.")
  
  expect_error(field_label(dat = data.frame(LOCATION = rep("BAMBEY", 10), 
                                            PLOT = 1001:1010, 
                                            ROW = c(rep(1, 6), rep(2, 4)),
                                            COLUMN = c(1:6, 1:4),
                                            REP = rep(1, 10),
                                            IBLOCK = c(rep(1, 6), rep(2, 4)),
                                            TREATMENT = paste0("G-", 1:10),
                                            SEED_SOURCE = rep("OFF_NUR", 10)),
                           
                                             rep_id = 'REP',
                                             plot_id = 'PLOT',
                                             row_id = 11, 
                                             col_id = 'COLUMN', 
                                             loc_id = 'LOCATION',
                                             entry_id = 'TREATMENT', 
                                             IBlock_id = 'IBLOCK', 
                                             get_unique_id = "ruid", 
                                             rname = "AW Kena", 
                                             seed_source = TRUE, 
                                             seed_source_id = "SEED_SOURCE" ),
               "'row_id' must be string value.")
  
  expect_error(field_label(dat = data.frame(LOCATION = rep("BAMBEY", 10), 
                                            PLOT = 1001:1010, 
                                            ROW = c(rep(1, 6), rep(2, 4)),
                                            COLUMN = c(1:6, 1:4),
                                            REP = rep(1, 10),
                                            IBLOCK = c(rep(1, 6), rep(2, 4)),
                                            TREATMENT = paste0("G-", 1:10),
                                            SEED_SOURCE = rep("OFF_NUR", 10)),
                           
                                             rep_id = 'REP',
                                             plot_id = 'PLOT',
                                             row_id = 'ROW', 
                                             col_id = 1, 
                                             loc_id = 'LOCATION',
                                             entry_id = 'TREATMENT', 
                                             IBlock_id = 'IBLOCK', 
                                             get_unique_id = "ruid", 
                                             rname = "AW Kena", 
                                             seed_source = TRUE, 
                                             seed_source_id = "SEED_SOURCE" ),
               "'col_id' must be string value.")
  
  expect_error(field_label(dat = data.frame(LOCATION = rep("BAMBEY", 10), 
                                            PLOT = 1001:1010, 
                                            ROW = c(rep(1, 6), rep(2, 4)),
                                            COLUMN = c(1:6, 1:4),
                                            REP = rep(1, 10),
                                            IBLOCK = c(rep(1, 6), rep(2, 4)),
                                            TREATMENT = paste0("G-", 1:10),
                                            SEED_SOURCE = rep("OFF_NUR", 10)),
                           
                                           rep_id = 'REP',
                                           plot_id = 'PLOT',
                                           row_id = 'ROW', 
                                           col_id = 'COLUMN', 
                                           loc_id = 1,
                                           entry_id = 'TREATMENT', 
                                           IBlock_id = 'IBLOCK', 
                                           get_unique_id = "ruid", 
                                           rname = "AW Kena", 
                                           seed_source = TRUE, 
                                           seed_source_id = "SEED_SOURCE" ),
               "'loc_id' must be string value.")
  
  
  expect_error(field_label(dat = data.frame(LOCATION = rep("BAMBEY", 10), 
                                            PLOT = 1001:1010, 
                                            ROW = c(rep(1, 6), rep(2, 4)),
                                            COLUMN = c(1:6, 1:4),
                                            REP = rep(1, 10),
                                            IBLOCK = c(rep(1, 6), rep(2, 4)),
                                            TREATMENT = paste0("G-", 1:10),
                                            SEED_SOURCE = rep("OFF_NUR", 10)),
                           
                                             rep_id = 'REP',
                                             plot_id = 'PLOT',
                                             row_id = 'ROW', 
                                             col_id = 'COLUMN', 
                                             loc_id = 'LOCATION',
                                             entry_id = 1, 
                                             IBlock_id = 'IBLOCK', 
                                             get_unique_id = "ruid", 
                                             rname = "AW Kena", 
                                             seed_source = TRUE, 
                                             seed_source_id = "SEED_SOURCE" ),
               "'entry_id' must be string value.")
  
  expect_error(field_label(dat = data.frame(LOCATION = rep("BAMBEY", 10), 
                                            PLOT = 1001:1010, 
                                            ROW = c(rep(1, 6), rep(2, 4)),
                                            COLUMN = c(1:6, 1:4),
                                            REP = rep(1, 10),
                                            IBLOCK = c(rep(1, 6), rep(2, 4)),
                                            TREATMENT = paste0("G-", 1:10),
                                            SEED_SOURCE = rep("OFF_NUR", 10)),
                           
                                             rep_id = 'REP',
                                             plot_id = 'PLOT',
                                             row_id = 'ROW', 
                                             col_id = 'COLUMN', 
                                             loc_id = 'LOCATION',
                                             entry_id = 'TREATMENT', 
                                             IBlock_id = 1, 
                                             get_unique_id = "ruid", 
                                             rname = "AW Kena", 
                                             seed_source = TRUE, 
                                             seed_source_id = "SEED_SOURCE" ),
               "'IBlock_id' must be string value.")
  
  
  expect_error(field_label(data.frame(LOCATION = rep("BAMBEY", 10), 
                           PLOT = 1001:1010, 
                           ROW = c(rep(1, 6), rep(2, 4)),
                           COLUMN = c(1:6, 1:4),
                           REP = rep(1, 10),
                           IBLOCK = c(rep(1, 6), rep(2, 4)),
                           TREATMENT = paste0("G-", 1:10),
                           SEED_SOURCE = rep("OFF_NUR", 10)),
                           font_sz = 10,
                           IBlock = FALSE,
                           get_unique_id = "go",
                           rname = "AWK",
                           family = "sans",
                           seed_source = FALSE ), 
               "'get_unique_id' must be a string value of one of these: 'ruid','uuid' or 'custom'")
  
  
  
  expect_error(field_label(data.frame(LOCATION = rep("BAMBEY", 10), 
                                      PLOT = 1001:1010, 
                                      ROW = c(rep(1, 6), rep(2, 4)),
                                      COLUMN = c(1:6, 1:4),
                                      REP = rep(1, 10),
                                      IBLOCK = c(rep(1, 6), rep(2, 4)),
                                      TREATMENT = paste0("G-", 1:10),
                                      SEED_SOURCE = rep("OFF_NUR", 10)),
                                       font_sz = 10,
                                       IBlock = FALSE,
                                       get_unique_id = "ruid",
                                       rname = "AWK",
                                       family = "sans",
                                       seed_source = TRUE ,
                                       seed_source_id = NULL), 
               "Use the 'seed_source_id' argument to specify the column name in your fieldbook containing seed source ids.")
  
  expect_error(field_label(data.frame(LOCATION = rep("BAMBEY", 10), 
                                      PLOT = 1001:1010, 
                                      ROW = c(rep(1, 6), rep(2, 4)),
                                      COLUMN = c(1:6, 1:4),
                                      REP = rep(1, 10),
                                      IBLOCK = c(rep(1, 6), rep(2, 4)),
                                      TREATMENT = paste0("G-", 1:10),
                                      SEED_SOURCE = rep("OFF_NUR", 10)),
                                       font_sz = 10,
                                       IBlock = FALSE,
                                       get_unique_id = "ruid",
                                       rname = "AWK",
                                       family = "sans",
                                       seed_source = FALSE,
                                       Year = 11111), 
               "Year must be a string or numeric value of four characters.")
  
  expect_error(field_label(data.frame(LOCATION = rep("BAMBEY", 10), 
                                      PLOT = 1001:1010, 
                                      ROW = c(rep(1, 6), rep(2, 4)),
                                      COLUMN = c(1:6, 1:4),
                                      REP = rep(1, 10),
                                      IBLOCK = c(rep(1, 6), rep(2, 4)),
                                      TREATMENT = paste0("G-", 1:10),
                                      SEED_SOURCE = rep("OFF_NUR", 10)),
                                       font_sz = 10,
                                       IBlock = FALSE,
                                       get_unique_id = "ruid",
                                       rname = "AWK",
                                       family = "sans",
                                       seed_source = TRUE,
                                       seed_source_id = 1), 
               "Seed source ID must be a string value.")
  
  expect_error(field_label(data.frame(LOCATION = rep("BAMBEY", 10), 
                                      PLOT = 1001:1010, 
                                      ROW = c(rep(1, 6), rep(2, 4)),
                                      COLUMN = c(1:6, 1:4),
                                      REP = rep(1, 10),
                                      IBLOCK = c(rep(1, 6), rep(2, 4)),
                                      TREATMENT = paste0("G-", 1:10),
                                      SEED_SOURCE = rep("OFF_NUR", 10)),
                                       font_sz = 10,
                                       IBlock = FALSE,
                                       get_unique_id = "ruid",
                                       rname = 11,
                                       family = "sans",
                                       seed_source = FALSE), 
               "Researcher name must be a string value.")
  
  
  expect_error(field_label(data.frame(LOCATION = rep("BAMBEY", 10), 
                                      PLOT = 1001:1010, 
                                      ROW = c(rep(1, 6), rep(2, 4)),
                                      COLUMN = c(1:6, 1:4),
                                      REP = rep(1, 10),
                                      IBLOCK = c(rep(1, 6), rep(2, 4)),
                                      TREATMENT = paste0("G-", 1:10),
                                      SEED_SOURCE = rep("OFF_NUR", 10)),
                                       font_sz = 10,
                                       IBlock = FALSE,
                                       get_unique_id = "ruid",
                                       rname = 'AWK',
                                       family = "sans",
                                       seed_source = 11), 
               "'seed_source' must be a logical or boolean value.")
  
  expect_error(field_label(data.frame(LOCATION = rep("BAMBEY", 10), 
                                      PLOT = 1001:1010, 
                                      ROW = c(rep(1, 6), rep(2, 4)),
                                      COLUMN = c(1:6, 1:4),
                                      REP = rep(1, 10),
                                      IBLOCK = c(rep(1, 6), rep(2, 4)),
                                      TREATMENT = paste0("G-", 1:10),
                                      SEED_SOURCE = rep("OFF_NUR", 10)),
                                       font_sz = 10,
                                       IBlock = FALSE,
                                       get_unique_id = "ruid",
                                       rname = 'AWK',
                                       family = "sans",
                                       seed_source = FALSE,
                                        Trial = 10), 
               "'Trial' must be string value.")
  
  
})