% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coord_time.R
\name{coord_time}
\alias{coord_time}
\title{Time elapsed (in years) since the beginning of the year}
\usage{
coord_time(date.event, random.e = TRUE)
}
\arguments{
\item{date.event}{A character vector with the dates of events in format either "yyyy-mm-dd" or "yyyy-mm-dd hour:min:secs" (for instance, "2016-01-20 12:00:00") of a population.
If "hour:min:secs" is omitted the function imputes either "12:00:00", if `random.e = FALSE`, or
a random hour, by default.}

\item{random.e}{A `TRUE/FALSE` argument indicating whether the exact moment ("hour:min:secs") when the event occurs within the day is randomly selected. This overwrites "hour:min:secs" in `date.event` even if this has been declared.}
}
\value{
A numeric vector of the same length as data.event

 @seealso \code{\link{coord_age}}, \code{\link{exact_age}}
}
\description{
Computes the time(s) elapsed (in years) between the beginning of the year and the date(s) of the event(s). The time coordinate(s) in a Lexis diagram.
}
\note{
The length of the year is 365 days in non-leap years and 366 days in leap years.
}
\examples{
dates <- c("2002-03-23", "2009-04-12", "2019-01-01")
coord_time(dates)
dates <- "2019-01-01 14:00:00"
coord_time(dates, FALSE)
}
\references{
Pavia, JM and Lledo, J (2022). Estimation of the Combined Effects of Ageing and Seasonality on Mortality Risk. An application to Spain. *Journal of the Royal Statistical Society, Series A (Statistics in Society)*, 185(2), 471-497. \doi{10.1111/rssa.12769}
}
\author{
Jose M. Pavia \email{pavia@uv.es}

Josep Lledo \email{josep.lledo@uv.es}
}
