% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qgis-plugins.R
\name{qgis_enable_plugins}
\alias{qgis_enable_plugins}
\alias{qgis_disable_plugins}
\title{Enable or disable QGIS plugins}
\usage{
qgis_enable_plugins(names = NULL, quiet = FALSE)

qgis_disable_plugins(names = NULL, quiet = FALSE)
}
\arguments{
\item{names}{Optional character vector of plugin names.}

\item{quiet}{Use \code{FALSE} to display more information,
possibly useful for debugging.}
}
\value{
A tibble of plugins, invisibly.
}
\description{
Processing plugins, installed in QGIS, can be in an 'enabled' or 'disabled'
state in QGIS.
The plugin state can be controlled from R.
\code{qgis_enable_plugins()} enables plugins while \code{qgis_disable_plugins()}
does the reverse.
}
\details{
The cache is immediately updated upon enabling or disabling plugins from R.

Run \code{\link[=qgis_plugins]{qgis_plugins()}} to list the available plugins that implement processing
providers.

If you installed, removed, enabled or disabled plugins in the QGIS GUI, then
run \code{\link[=qgis_configure]{qgis_configure()}} to make those changes available in R.

If \code{names} is not provided to \code{qgis_enable_plugins()}, it is assumed that all
\emph{disabled} plugins are to be enabled.
If \code{names} is not provided to \code{qgis_disable_plugins()}, it is assumed that all
\emph{enabled} plugins are to be disabled.
Note that the 'processing' plugin is ignored, because it is always available
to 'qgis_process' (not QGIS though).
}
\note{
Only plugins that implement processing providers are supported.
Installing or removing plugins is not supported.
}
\examples{
\dontshow{if (has_qgis()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
qgis_enable_plugins("name_of_plugin")
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=qgis_plugins]{qgis_plugins()}}

Other topics about configuring QGIS and qgisprocess: 
\code{\link{qgis_configure}()},
\code{\link{qgis_run}()}
}
\concept{functions to manage and explore QGIS and qgisprocess}
\concept{topics about configuring QGIS and qgisprocess}
