% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qfa4.0.R
\name{sar.eq.bootstrap}
\alias{sar.eq.bootstrap}
\title{Bootstrap Simulation of SAR Coefficients for Testing Equality of Granger-Causality in Two Samples}
\usage{
sar.eq.bootstrap(
  y.qser,
  fit,
  fit2,
  index = c(1, 2),
  nsim = 1000,
  method = c("ar", "sar"),
  n.cores = 1,
  mthreads = TRUE,
  seed = 1234567
)
}
\arguments{
\item{y.qser}{matrix or array of QSER from \code{qser()} or \code{qspec.sar()$qser}}

\item{fit}{object of SAR model from \code{qser2sar()} or \code{qspec.sar()$fit}}

\item{fit2}{object of SAR model for the other sample}

\item{index}{a pair of component indices for multiple time series 
or a sequence of lags for single time series (default = \code{c(1,2)})}

\item{nsim}{number of bootstrap samples (default = 1000)}

\item{method}{method of residual calculation: \code{"ar"} (default) or \code{"sar"}}

\item{n.cores}{number of cores for parallel computing (default = 1)}

\item{mthreads}{if \code{FALSE}, set \code{RhpcBLASctl::blas_set_num_threads(1)} (default = \code{TRUE})}

\item{seed}{seed for random sampling (default = \code{1234567})}
}
\value{
array of simulated bootstrap samples of selected SAR coefficients
}
\description{
This function simulates bootstrap samples of selected spline autoregression (SAR) coefficients 
for testing equality of Granger-causality in two samples based on their SAR models
under H0: effect in each sample equals the average effect.
}
\examples{
y11 <- stats::arima.sim(list(order=c(1,0,0), ar=0.5), n=64)
y21 <- stats::arima.sim(list(order=c(1,0,0), ar=-0.5), n=64)
y12 <- stats::arima.sim(list(order=c(1,0,0), ar=0.5), n=64)
y22 <- stats::arima.sim(list(order=c(1,0,0), ar=-0.5), n=64)
tau <- seq(0.1,0.9,0.05)
y1.sar <- qspec.sar(cbind(y11,y21),tau=tau,p=1)
y2.sar <- qspec.sar(cbind(y12,y22),tau=tau,p=1)
A1.sim <- sar.eq.bootstrap(y1.sar$qser,y1.sar$fit,y2.sar$fit,index=c(1,2),nsim=5)
A2.sim <- sar.eq.bootstrap(y2.sar$qser,y2.sar$fit,y1.sar$fit,index=c(1,2),nsim=5)
}
