% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qfa2.0.R
\name{sar.gc.bootstrap}
\alias{sar.gc.bootstrap}
\title{Bootstrap Simulation of SAR Coefficients for Granger-Causality Analysis}
\usage{
sar.gc.bootstrap(
  y.qser,
  fit,
  index = c(1, 2),
  nsim = 1000,
  n.cores = 1,
  mthreads = FALSE,
  seed = 1234567
)
}
\arguments{
\item{y.qser}{matrix or array of QSER from \code{qser()} or \code{qspec.sar()$qser}}

\item{fit}{object of SAR model from \code{qser2sar()} or \code{qspec.sar()$fit}}

\item{index}{a pair of component indices for multiple time series 
or a sequence of lags for single time series (default = \code{c(1,2)})}

\item{nsim}{number of bootstrap samples (default = 1000)}

\item{n.cores}{number of cores for parallel computing (default = 1)}

\item{mthreads}{if \code{TRUE}, multithread BLAS is enabled when available (default = \code{FALSE}, required for parallel computing)}

\item{seed}{seed for random sampling (default = \code{1234567})}
}
\value{
array of simulated bootstrap samples of selected SAR coefficients
}
\description{
This function simulates bootstrap samples of selected spline autoregression (SAR) coefficients 
for Granger-causality analysis based on the SAR model of quantile series (QSER) under H0: 
(a) for multiple time series, the second series specified in \code{index} is not causal 
for the first series specified in \code{index};
(b) for single time series, the series is not causal at the lags specified in \code{index}.
}
\examples{
y1 <- stats::arima.sim(list(order=c(1,0,0), ar=0.5), n=64)
y2 <- stats::arima.sim(list(order=c(1,0,0), ar=-0.5), n=64)
tau <- seq(0.1,0.9,0.05)
y.sar <- qspec.sar(cbind(y1,y2),tau=tau,p=1)
A.sim <- sar.gc.bootstrap(y.sar$qser,y.sar$fit,index=c(1,2),nsim=5)
}
