% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/word_list.R
\name{word_list}
\alias{word_list}
\title{Raw Word Lists/Frequency Counts}
\usage{
word_list(text.var, grouping.var = NULL, stopwords = NULL,
  alphabetical = FALSE, cut.n = 20, cap = TRUE, cap.list = NULL,
  cap.I = TRUE, rm.bracket = TRUE, char.keep = NULL,
  apostrophe.remove = FALSE, ...)
}
\arguments{
\item{text.var}{The text variable.}

\item{grouping.var}{The grouping variables.  Default \code{NULL} generates 
one word list for all text.  Also takes a single grouping variable or a list 
of 1 or more grouping variables.}

\item{stopwords}{A vector of stop words to remove.}

\item{alphabetical}{If \code{TRUE} the output of frequency lists is ordered 
alphabetically.  If \code{FALSE} the list is ordered by frequency rank.}

\item{cut.n}{Cut off point for reduced frequency stop word list (rfswl).}

\item{cap}{logical. If \code{TRUE} capitalizes words from the cap.list.}

\item{cap.list}{Vector of words to capitalize.}

\item{cap.I}{logical. If \code{TRUE} capitalizes words containing the 
personal pronoun I.}

\item{rm.bracket}{logical If \code{TRUE} all brackets and bracketed text are 
removed from analysis.}

\item{char.keep}{A character vector of symbols (i.e., punctuation) that 
\code{word_list} should keep.  The default is to remove every symbol except 
apostrophes.}

\item{apostrophe.remove}{logical.  If \code{TRUE} removes apostrophes from 
the output.}

\item{\ldots}{Other arguments passed to \code{\link[qdap]{strip}}.}
}
\value{
An object of class \code{"word_list"} is a list of lists of vectors 
or dataframes containing the following components: 
\item{cwl}{complete word list; raw words}
\item{swl}{stop word list; same as rwl with stop words removed}
\item{fwl}{frequency word list; a data frame of words and corresponding 
frequency counts}
\item{fswl}{frequency stopword word list; same as fwl but with stop words 
removed}
\item{rfswl}{reduced frequency stopword word list; same as fswl but truncated 
to n rows}
}
\description{
Transcript Apply Raw Word Lists and Frequency Counts by grouping variable(s).
}
\examples{
\dontrun{
word_list(raj.act.1$dialogue)

out1 <- with(raj, word_list(text.var = dialogue, 
    grouping.var = list(person, act)))
names(out1)
lapply(out1$cwl, "[", 1:5)

with(DATA, word_list(state, person))
with(DATA, word_list(state, person, stopwords = Top25Words))
with(DATA, word_list(state, person, cap = FALSE, cap.list=c("do", "we")))
}
}
\keyword{word-list}
