% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qb_apps.R
\name{get_app_events}
\alias{get_app_events}
\title{Get app events}
\usage{
get_app_events(subdomain, auth, app_id, agent = NULL)
}
\arguments{
\item{subdomain}{Character vector with one element. Found at the beginning of
the Quickbase URL. Realm specific.}

\item{auth}{Character vector with one element. The Quickbase authentication
scheme you are using to authenticate the request (e.g., user token).}

\item{app_id}{Character vector with one element. Unique identifier of an app.
Found in the URL of the app's homepage after /db/}

\item{agent}{Optional. Character vector with one element. Describes
user/agent making API call.}
}
\value{
A tibble.
}
\description{
\code{get_app_events} Get a tibble of events that can be triggered based on
data or user actions in this application, includes: Email notification,
Reminders, Subscriptions, QB Actions, Webhooks, record change triggered
Automations (does not include scheduled).
}
\examples{
\dontrun{
   get_app_events(subdomain = "abc",
                  auth = keyring::key_get("qb_example"),
                  app_id = "bn9d8f78g")
}
}
