% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modify_cells2.R
\name{px_values}
\alias{px_values}
\alias{px_values.px}
\title{VALUES}
\usage{
px_values(x, value, validate)

\method{px_values}{px}(x, value, validate = TRUE)
}
\arguments{
\item{x}{A px object}

\item{value}{Optional. A data frame with the columns 'values' and one or more of the columns: 'variable-code', 'code', and 'language'. If 'value' is missing, the current VALUES is returned. If NULL, VALUES is removed.}

\item{validate}{Optional. If TRUE a number of validation checks are performed on the px object, and an error is thrown if the object is not valid. If FALSE, the checks are skipped, which can be usefull for large px objects where the check can be time consuming. Use \code{\link[=px_validate]{px_validate()}} to manually preform the check.}
}
\value{
A px object or data frame.
}
\description{
Inspect or change VALUES.
}
\examples{
# Set VALUES for a value
library(tibble)
x1 <-
  population_gl |>
  px() |>
  px_values(
    tribble(~`variable-code`, ~code,  ~values,
            'year', '2004', 'Year 2024'))

# Print VALUES
px_values(x1)

# Set VALUES for a value in specific language
x2 <-
  x1 |>
  px_languages(c('en', 'kl')) |>
  px_values(
    tribble(~`variable-code`, ~code,  ~language, ~values,
            'age', '0-6', 'en', 'toddler',
            'age', '0-6', 'kl', 'meeraaqqap'))
px_values(x2)

# Remove VALUES
x3 <- px_values(x2, NULL)
px_values(x3)
}
\seealso{
\href{https://www.scb.se/globalassets/vara-tjanster/px-programmen/px-file_format_specification_2013.pdf#\%5B\%7B\%22num\%22\%3A36\%2C\%22gen\%22\%3A0\%7D\%2C\%7B\%22name\%22\%3A\%22XYZ\%22\%7D\%2C184\%2C212\%2C0\%5D}{Statistics Sweden's documentation}
}
