% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta_plot.R
\name{meta_plot}
\alias{meta_plot}
\title{Meta-plot}
\usage{
meta_plot(m1i, m2i, sd1i, sd2i, n1i, n2i, gi, vgi, ri, ni, ai, bi, ci, di,
  alpha = 0.05, method_tau2 = "PM", nr_lines = "all",
  pub_bias = TRUE, main = "", cex.pch = 1)
}
\arguments{
\item{m1i}{A vector of means in group 1 for two-independent means}

\item{m2i}{A vector of means in group 2 for two-independent means}

\item{sd1i}{A vector of standard deviations in group 1 for two-independent means}

\item{sd2i}{A vector of standard deviations in group 2 for two-independent means}

\item{n1i}{A vector of sample sizes in group 1 for two-independent means}

\item{n2i}{A vector of sample sizes in group 2 for two-independent means}

\item{gi}{A vector of Hedges' g values for two-independent means if group means 
and standard deviations are not available}

\item{vgi}{A vector of Hedges' g sampling variances for two-independent means 
if group means and standard deviations are not available}

\item{ri}{A vector of raw correlations}

\item{ni}{A vector of sample sizes if raw correlations are the effect size measure}

\item{ai}{A vector of frequencies in upper left cell of 2x2 frequency table
(see Details)}

\item{bi}{A vector of frequencies in upper right cell of 2x2 frequency table
(see Details)}

\item{ci}{A vector of frequencies in lower left cell of 2x2 frequency table
(see Details)}

\item{di}{A vector of frequencies in lower right cell of 2x2 frequency table
(see Details)}

\item{alpha}{A integer specifying the alpha level as used in primary studies
(default is 0.05 but see Details)}

\item{method_tau2}{A character indicating the estimation method for the 
between-study variance in true effect size in the meta-analysis 
(default is \code{"PM"}, but see Details)}

\item{nr_lines}{A character indicating whether all primary study's effect sizes
(\code{"all"}, default) or a selection of primary study's effect sizes 
(\code{"summary"}) are plotted (see Details)}

\item{pub_bias}{A logical indicating whether the expected results of the cumulative 
meta-analysis based on a zero true effect in combination with extreme publication 
bias should be plotted (default is TRUE). Note that these results are only 
included if at least 80\% of the primary studies is statistically significant 
regardless of the \code{pub_bias} parameter}

\item{main}{A character indicating the title of the plot (default is no title)}

\item{cex.pch}{An integer to control the size of the points in the plot}
}
\value{
An invisibly returned data frame consisting of the submitted data and
\item{yi}{Standardized effect sizes used in the analyses}
\item{vi}{Sampling variances of the standardized effect sizes used in the analyses}
\item{est_cum}{Estimates of the cumulative meta-analyses}
\item{lb_cum}{Lower bounds of the 95\% confidence intervals of the cumulative meta-analyses}
\item{ub_cum}{Upper bounds of the 95\% confidence intervals of the cumulative meta-analyses}
\item{pub_est}{Estimates of cumulative meta-analyses based on Mill's ratios}
\item{info}{Information of a primary study (only for two-independent means)}
\item{stand_info}{Standardized information of a primary study (only for 
two-independent means)}
\item{preci}{Precision of a primary study (only for odds ratios)}
}
\description{
Function to create meta-plots for two-independent means, raw correlations, and 
odds ratios. See van Assen et al. (2019) for more information.
}
\details{
The \code{meta_plot} function assumes that two-tailed hypothesis tests 
were conducted in the primary studies. In case one-tailed hypothesis tests were 
conducted in the primary studies, the submitted \code{alpha} argument to the 
\code{meta_plot} function has to be multiplied by two. For example, if one-tailed 
hypothesis tests were  conducted with an alpha level of .05, an alpha of 0.1 
has to be submitted to the \code{meta_plot} function.

Different estimators can be used for estimating the between-study variance in 
true effect size. The default estimator is the Paule-Mandel estimator 
(Paule & Mandel, 1982), because this estimator was recommended in Veroniki 
et al. (2016) and Langan, Higgins, and Simmonds (2016). However, all estimators 
that are included in the \code{rma.uni} function of the \code{metafor} package 
can be used, because this function is called in the \code{meta_plot} function.

When \code{nr_lines = "summary"} is specified, the estimates of meta-analyses 
based on primary studies with sufficient statistical power are displayed.
Next to the estimate and 95\% confidence interval of the meta-analysis including 
all studies (leftmost), it shows these results for studies with sufficient 
statistical power (80\%) to detect a large true effect size (left vertical line), 
medium true effect size (middle), and small true effect size (right). Note 
that the summary meta-plot is just the meta-plot with many meta-analyses and 
confidence intervals left out, and keeping the leftmost meta-analysis and 
those just immediately to the right of the vertical lines.

For creating a meta-plot based on odds ratios as effect size measure, the 2x2 
frequency table should follow a specific format. The reason for this is that 
the probability for the outcome of interest in the control conditions has 
to be estimated. Hence, the 2x2 frequency table should look like this:
}
\examples{
### Load data from meta-analysis by McCall and Carriger (1993)
data(data.mccall93)

### Create meta-plot
meta_plot(ri = data.mccall93$ri, ni = data.mccall93$ni)

### Create summary meta-plot
meta_plot(ri = data.mccall93$ri, ni = data.mccall93$ni, nr_lines = "summary")

}
\references{
Langan, D., Higgins, J. P. T., & Simmonds, M. (2016). Comparative 
performance of heterogeneity variance estimators in meta-analysis: A review of 
simulation studies. Research Synthesis Methods, 8(2), 181-198. doi:10.1002/jrsm.1198

Veroniki, A. A., Jackson, D., Viechtbauer, W., Bender, R., Bowden, J., 
Knapp, G., . . . Salanti, G. (2016). Methods to estimate the between-study variance 
and its uncertainty in meta-analysis. Research Synthesis Methods, 7(1), 55-79. 
doi:10.1002/jrsm.1164

van Assen, ..., & van Aert (2019). The meta-plot. Manuscript in 
preparation.
}
\author{
Robbie C.M. van Aert \email{R.C.M.vanAert@tilburguniversity.edu}
}
