% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/descriptive_functions.R
\name{estat}
\alias{estat}
\title{Descriptive statistics for continuous variables.}
\usage{
estat(formula, data, digits = 2, label = NULL)
}
\arguments{
\item{formula}{A formula of the form: ~ x or ~ x|z (for groups).}

\item{data}{A data frame where the variables in the \code{formula} can be found.}

\item{digits}{Number of digits for rounding (default = 2).}

\item{label}{Label used to display the name of the variable (see examples).}
}
\value{
A data frame with descriptive statistics.
}
\description{
\code{estat} calculates descriptives of numerical variables.
}
\examples{
data(kfm, package = "ISwR")
estat(~ dl.milk, data = kfm, label = "Breast-milk intake (dl/day)")
estat(~ dl.milk|sex, data = kfm, label = "Breast-milk intake (dl/day)")
estat(~ weight|sex, data = kfm, label = "Weight of child (kg)")
}
\seealso{
\link{summary}, \code{summarize}.
}
\author{
Josie Athens, Department of Preventive and Social Medicine, University of Otago, New Zealand.
}
