% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ranef.R
\name{ranef}
\alias{ranef}
\title{Compute random effects for Poisson-Tweedie and negative binomial mixed model}
\usage{
ranef(obj)
}
\arguments{
\item{obj}{an object of class \code{ptglmm} (obtained from 
\code{ptmixed} or \code{nbmixed} ).}
}
\value{
A vector with the EB estimates of the random effects
}
\description{
Compute the BLUP (best linear unbiased predictor) of the random  
effects for the Poisson-Tweedie and negative binomial generalized 
linear mixed models (fitted through \code{ptmixed} and 
\code{nbmixed} respectively)
}
\examples{
\donttest{

data(df1, package = 'ptmixed')

# estimate a Poisson-Tweedie or negative binomial GLMM (using
# ptmixed() or nbmixed())
fit0 = nbmixed(fixef.formula = y ~ group + time, id = id,
              offset = offset, data = df1, npoints = 5, 
              freq.updates = 200, hessian = FALSE, trace = TRUE)
              
# obtain random effect estimates
ranef(obj = fit0)
}
}
\references{
Signorelli, M., Spitali, P., Tsonaka, R. (2020). Poisson-Tweedie 
mixed-effects model: a flexible approach for the analysis of longitudinal RNA-seq
data. Statistical Modelling. URL: https://doi.org/10.1177/1471082X20936017
}
\seealso{
\code{\link{ptmixed}}, \code{\link{nbmixed}}
}
\author{
Mirko Signorelli
}
