% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprecated.R
\name{analyze.lmerModLmerTest}
\alias{analyze.lmerModLmerTest}
\title{Analyze lmerModLmerTest objects.}
\usage{
\method{analyze}{lmerModLmerTest}(x, CI = 95,
  effsize_rules = "cohen1988", ...)
}
\arguments{
\item{x}{lmerModLmerTest object.}

\item{CI}{Bootsrapped confidence interval bounds (slow). Set to NULL turn off their computation.}

\item{effsize_rules}{Grid for effect size interpretation. See \link[=interpret_d]{interpret_d}.}

\item{...}{Arguments passed to or from other methods.}
}
\value{
output
}
\description{
Analyze lmerModLmerTest objects.
}
\examples{
library(psycho)
library(lmerTest)
fit <- lmerTest::lmer(Sepal.Length ~ Sepal.Width + (1 | Species), data = iris)

results <- analyze(fit)
summary(results)
print(results)
}
\references{
Nakagawa, S., & Schielzeth, H. (2013). A general and simple method for obtaining R2 from generalized linear mixed-effects models. Methods in Ecology and Evolution, 4(2), 133-142.
}
\author{
\href{https://dominiquemakowski.github.io/}{Dominique Makowski}
}
