% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rope.R
\name{rope}
\alias{rope}
\title{Region of Practical Equivalence (ROPE)}
\usage{
rope(posterior, bounds = c(-0.1, 0.1), CI = 95, overlap = FALSE)
}
\arguments{
\item{posterior}{Posterior Distribution.}

\item{bounds}{Rope lower and higher bounds.}

\item{CI}{The credible interval to use.}

\item{overlap}{Compute rope overlap (EXPERIMENTAL).}
}
\value{
list containing rope indices
}
\description{
Compute the proportion of a posterior distribution that lies within a region of practical equivalence.
}
\examples{
library(psycho)

posterior <- rnorm(1000, 0, 0.01)
results <- rope(posterior)
results$decision
}
\author{
\href{https://dominiquemakowski.github.io/}{Dominique Makowski}
}
