% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/standardize.R
\name{standardize.lm}
\alias{standardize.lm}
\title{Standardize Coefficients.}
\usage{
\method{standardize}{lm}(x, partial_SD = TRUE, ...)
}
\arguments{
\item{x}{A linear model.}

\item{partial_SD}{Use partial SD.}

\item{...}{Arguments passed to or from other methods.}
}
\description{
Compute standardized coefficients.
}
\examples{
\dontrun{
library(psycho)
fit <- lm(Adjusting ~ Tolerating, data=psycho::affective)
fit <- lmerTest::lmer(Sepal.Length ~ Sepal.Width + (1|Species), data=iris)

standardize(fit)

}

}
\author{
Kamil Barton
}
