% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/composites.R
\name{composite_rel_scalar}
\alias{composite_rel_scalar}
\title{Scalar formula to estimate the reliability of a composite variable}
\usage{
composite_rel_scalar(mean_rel, mean_intercor, k_vars)
}
\arguments{
\item{mean_rel}{The mean reliability of variables in the composite.}

\item{mean_intercor}{The mean correlation among the variables in the composite.}

\item{k_vars}{The number of variables in the composite.}
}
\value{
The estimated reliability of the composite variable.
}
\description{
This function computes the reliability of a variable that is a unit-weighted composite of other variables.
}
\details{
The Mosier composite formula is computed as:

\deqn{\rho_{XX}=\frac{\bar{\rho}_{x_{i}x_{i}}k+k\left(k-1\right)\bar{\rho}_{x_{i}x_{j}}}{k+k\left(k-1\right)\bar{\rho}_{x_{i}x_{j}}}}{rel_composite = (mean_rel * k_vars + k_vars * (k_vars-1) * mean_intercor) / (k_vars + k_vars * (k_vars-1) * mean_intercor)}

where \eqn{\bar{\rho}_{x_{i}x_{i}}}{mean_rel} is the mean reliability of variables in the composite, \eqn{\bar{\rho}_{x_{i}x_{j}}}{mean_intercor} is the mean intercorrelation among variables in the composite, and \emph{k} is the number of variables in the composite.
}
\examples{
composite_rel_scalar(mean_rel = .8, mean_intercor = .4, k_vars = 2)
}
\references{
Mosier, C. I. (1943). On the reliability of a weighted composite.
\emph{Psychometrika, 8}(3), 161–168. \doi{10.1007/BF02288700}

Schmidt, F. L., & Hunter, J. E. (2015).
\emph{Methods of meta-analysis: Correcting error and bias in research findings} (3rd ed.).
Thousand Oaks, CA: Sage. \doi{10.4135/9781483398105}. pp. 441 - 447.
}
