% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_ad.R
\name{.create_ad_int}
\alias{.create_ad_int}
\title{Create a tabular array of artifact information summarizing values and weights of values in an interactive artifact distribution}
\usage{
.create_ad_int(art_vec, wt_vec = rep(1, length(art_vec)), decimals = Inf)
}
\arguments{
\item{art_vec}{Vector of artifact values (i.e., u ratios, reliability coefficients, square-root reliabilities).}

\item{wt_vec}{Vector for weights to assign to individual artifact values.}

\item{decimals}{Number of decimals to which artifact values should be rounded and consolidated.}
}
\value{
Data frame with two columns: One containing artifact values and the other containing weights associated with artifact values.
}
\description{
This is an internal function that constructs a data frame of artifact estimates (in the Value column) and corresponding weights (in the Weight column), consolidated according to the specified number of digits used in rounding.
}
\examples{
# .create_ad_int(art_vec = c(.8, .8, .9), wt_vec = c(100, 200, 100), decimals = 2)

}
\keyword{internal}
