% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ma_wrappers.R
\name{ma_wrapper}
\alias{ma_wrapper}
\title{Wrapper function to compute meta-analytic results for all analyses.}
\usage{
ma_wrapper(es_data, es_type = "r", ma_type = "bb", ma_fun,
  moderator_matrix = NULL, moderator_type = "all", cat_moderators = TRUE,
  construct_x = NULL, construct_y = NULL, ma_arg_list, ...)
}
\arguments{
\item{es_data}{Matrix of effect-size data.}

\item{es_type}{Effect-size type (e.g., "r" or "d")}

\item{ma_type}{The meta-analysis type: "bb" or "individual_correction."}

\item{ma_fun}{Meta-analysis function to be used in computing meta-analytic results.}

\item{moderator_matrix}{Matrix (or vector) of moderator variables.}

\item{moderator_type}{Type of moderator analysis: "none" means that no moderators are to be used, "simple" means that moderators are to be examined one at a time,
"hierarchical" means that all possible combinations and subsets of moderators are to be examined, and "all" means that simple and hierarchical moderator analyses are to be performed.}

\item{cat_moderators}{Logical vector identifying whether each variable in the moderator_matrix is a categorical variable (TRUE) or a continuous variable (FALSE).}

\item{construct_x}{Vector of construct names for construct X.}

\item{construct_y}{Vector of construct names for construct Y.}

\item{ma_arg_list}{List of arguments to be passed to the meta-analysis function.}

\item{...}{Further arguments.}
}
\value{
A list of meta-analytic results.
}
\description{
Wrapper function to compute meta-analytic results for all analyses.
}
\keyword{internal}
