% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fn_psdr_bic.R
\name{psdr_bic}
\alias{psdr_bic}
\title{Order estimation via BIC-type criterion}
\usage{
psdr_bic(obj, rho = 0.01, plot = TRUE, ...)
}
\arguments{
\item{obj}{The psdr object}

\item{rho}{Parameter for BIC criterion. Default is 0.01.}

\item{plot}{Boolean. If TRUE, the plot of BIC values are depicted.}

\item{...}{Additional arguments to be passed to generic \code{plot} function.}
}
\value{
Estimated BIC scores for determining the optimal structural dimension will be returned with plot.
}
\description{
Estimation of a structural dimensionality. Choose the k which maximizes a BIC (Bayesian information criterion) value.
}
\examples{
\donttest{
set.seed(1234)
n <- 200; p <- 10;
x <- matrix(rnorm(n*p, 0, 1), n, p)
y <-  x[,1]/(0.5 + (x[,2] + 1)^2) + rnorm(n, 0, .2)
obj <- psdr(x, y, loss="svm")
d.hat <- psdr_bic(obj)
print(d.hat)
}

}
\references{
Li, B., Artemiou, A. and Li, L. (2011)
\emph{Principal support vector machines for linear and
nonlinear sufficient dimension reduction, Annals of Statistics 39(6): 3182–3210}.
}
\seealso{
\code{\link{psdr}}
}
\author{
Jungmin Shin, \email{jungminshin@korea.ac.kr}, Seung Jun Shin, \email{sjshin@korea.ac.kr}, Andreas Artemiou \email{artemiou@uol.ac.cy}
}
