% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psrwe_powerprior.R
\name{rwe_ps_powerp}
\alias{rwe_ps_powerp}
\title{Get posterior samples based on PS-power prior approach}
\usage{
rwe_ps_powerp(
  data_withps,
  outcome_type = c("continuous", "binary"),
  total_borrow = 0,
  v_distance = NULL,
  prior_type = c("fixed", "random"),
  v_outcome = "Y",
  ...,
  seed = NULL
)
}
\arguments{
\item{data_withps}{A class \code{RWE_DWITHPS} list. See \code{\link{rwe_ps}}.}

\item{outcome_type}{Type of outcomes: \code{continuous} or \code{binary}}

\item{total_borrow}{Total number of subjects to be borrowed}

\item{v_distance}{Vector of distances in PS distributions for each stratum.
See \code{\link{rwe_ps_dist}}.}

\item{prior_type}{Whether treat power parameter as fixed (\code{fixed}) or
fully Bayesian (\code{random})}

\item{v_outcome}{Column name corresponding to the outcome}

\item{...}{extra parameters for calling function \code{\link{rwe_stan}}}

\item{seed}{Random seed}
}
\value{
A list with the following objects \describe{
    \item{post_theta}{Posterior samples of parameter of interest}
    \item{post_theta_stratum}{Posterior samples of parameter of interest in
    each stratum} \item{stan_rst}{Result from STAN sampling} }
}
\description{
Draw posterior samples of the parameters of interest for the PS-power prior
approach
}
\examples{
\donttest{
 dta_ps <- rwe_ps(ex_dta, v_covs = paste("V", 1:7, sep = ""),
                  v_grp = "Group", cur_grp_level = "current")
 ps_dist <- rwe_ps_dist(dta_ps, metric = "ovl")
 post_smps <- rwe_ps_powerp(dta_ps, outcome_type = "binary",
                            total_borrow = 30,
                            v_distance = ps_dist$Dist[1:5],
                            v_outcome = "Y")}
}
