% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psrwe_complikel.R
\name{rwe_ps_cl2arm}
\alias{rwe_ps_cl2arm}
\title{PS-Integrated Composite Likelihood Estimation for Randomized Study}
\usage{
rwe_ps_cl2arm(
  data_withps,
  v_arm = "Arm",
  trt_arm_level = 1,
  total_borrow = 0,
  ...
)
}
\arguments{
\item{data_withps}{A class \code{RWE_DWITHPS} list. See \code{\link{rwe_ps}}.}

\item{v_arm}{Column name corresponding treatment vs. control. Ignored for
single arm studies. two-arm randomized studies.}

\item{trt_arm_level}{Arm level for the treatment arm. Ignored for single-arm
studies.}

\item{total_borrow}{Total number of subjects to be borrowed}

\item{...}{Parameters for \code{\link{rwe_ps_cl}}}
}
\value{
A list with estimated treatment effect and the variance, as well as
    the estimated mean for the treatment and control arms
}
\description{
Estimate the treatment effect based on PS-integrated composite likelihood
approach. Subjects from the external data source augment an arm, usually the
control arm.
}
