% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S3method.R
\name{psrank}
\alias{psrank}
\alias{psrank.numeric}
\alias{psrank.formula}
\title{Calculation of Pseudo-Ranks}
\usage{
psrank(data, ...)

\method{psrank}{numeric}(data, group, ...)

\method{psrank}{formula}(formula, data, ...)
}
\arguments{
\item{data}{numerical vector or data.frame}

\item{...}{further arguments}

\item{group}{vector coding for the groups}

\item{formula}{formula object}
}
\value{
Returns a numerical vector containing the pseudo-ranks
}
\description{
Calculation of (mid) pseudo-ranks of a sample. In case of ties (i.e. equal values), the average of min pseudo-rank and max-pseudor-rank are taken (similar to rank with ties.method="average").
}
\examples{
df <- data.frame(data = round(rnorm(100)), group = c(rep(1,40),rep(2,40),rep(3,20)))
df$group <- as.factor(df$group)

## two ways to calculate pseudo-ranks

# Variant 1: use a vector for the data and a group vector
psrank(df$data,df$group)

# Variant 2: use a formula object, Note that only one group factor can be used
# that is, in data~group*group2 only 'group' will be used
psrank(data~group,df)
}
\seealso{
\code{\link{rank}}.
}
\keyword{export}
