% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/package.R
\docType{package}
\name{psborrow2-package}
\alias{psborrow2}
\alias{psborrow2-package}
\title{psborrow2: Bayesian Dynamic Borrowing Analysis and Simulation}
\description{
Bayesian dynamic borrowing is an approach to incorporating external data to supplement a randomized, controlled trial analysis in which external data are incorporated in a dynamic way (e.g., based on similarity of outcomes); see Viele 2013 \doi{10.1002/pst.1589} for an overview. This package implements the hierarchical commensurate prior approach to dynamic borrowing as described in Hobbes 2011 \doi{10.1111/j.1541-0420.2011.01564.x}. There are three main functionalities. First, 'psborrow2' provides a user-friendly interface for applying dynamic borrowing on the study results handles the Markov Chain Monte Carlo sampling on behalf of the user. Second, 'psborrow2' provides a simulation framework to compare different borrowing parameters (e.g. full borrowing, no borrowing, dynamic borrowing) and other trial and borrowing characteristics (e.g. sample size, covariates) in a unified way. Third, 'psborrow2' provides a set of functions to generate data for simulation studies, and also allows the user to specify their own data generation process. This package is designed to use the sampling functions from 'cmdstanr' which can be installed from \url{https://mc-stan.org/r-packages/}.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/Genentech/psborrow2}
  \item \url{https://genentech.github.io/psborrow2/index.html}
  \item Report bugs at \url{https://github.com/Genentech/psborrow2/issues}
}

}
\author{
\strong{Maintainer}: Matt Secrest \email{secrestm@gene.com} (\href{https://orcid.org/0000-0002-0939-4902}{ORCID})

Authors:
\itemize{
  \item Isaac Gravestock \email{isaac.gravestock@roche.com}
}

Other contributors:
\itemize{
  \item Craig Gower-Page \email{craig.gower-page@roche.com} [contributor]
  \item Genentech, Inc. [copyright holder, funder]
}

}
\keyword{internal}
