% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/provenance.R
\name{getKDE}
\alias{getKDE}
\title{Create a kernel density estimate}
\usage{
getKDE(x, from = NA, to = NA, bw = NA, adaptive = TRUE, log = FALSE)
}
\arguments{
\item{x}{a vector of numbers}

\item{from}{minimum age of the time axis. If NULL, this is set
automatically}

\item{to}{maximum age of the time axis. If NULL, this is set
automatically}

\item{bw}{the bandwidth of the KDE. If NULL, bw will be calculated
automatically using \code{botev()}}

\item{adaptive}{boolean flag controlling if the adaptive KDE
modifier of Abramson (1982) is used}

\item{log}{transform the ages to a log scale if TRUE}
}
\description{
Turns a vector of numbers into an object of class \code{KDE} using
a combination of the Botev (2010) bandwidth selector and the
Abramson (1982) adaptive kernel bandwidth modifier.
}
\examples{
fname <- system.file("DZ.csv",package="provenance")
DZ <- read.DZdata(fname)
samp <- DZ$x[['N1']]
dens <- getKDE(samp,0,3000)
plot(dens)
}

