/*
 * Decompiled with CFR 0.152.
 */
package com.qarks.util.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;

public class DialogUtilities {
    private DialogUtilities() {
    }

    public static void centerWindow(Window window, Component component) {
        if (component != null && component.isShowing()) {
            Dimension dimension = window.getSize();
            Dimension dimension2 = component.getSize();
            Point point = component.getLocationOnScreen();
            if (point.x + dimension2.width > 0 && point.y + dimension2.height > 0) {
                Point point2 = new Point(point.x + (dimension2.width - dimension.width) / 2, point.y + (dimension2.height - dimension.height) / 2);
                window.setLocation(point2);
                window.setVisible(true);
            } else {
                DialogUtilities.centerOnScreen(window);
            }
        } else {
            DialogUtilities.centerOnScreen(window);
        }
    }

    public static void centerOnScreen(Window window) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        window.setLocation((int)(dimension.getWidth() - (double)window.getWidth()) / 2, (int)(dimension.getHeight() - (double)window.getHeight()) / 2);
        if (!window.isShowing()) {
            window.setVisible(true);
        }
    }

    public static void packAndRelocate(Window window) {
        window.pack();
        Dimension dimension = window.getSize();
        Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
        int n = 50;
        boolean bl = false;
        if (dimension2.width - n < dimension.width) {
            dimension.width = dimension2.width - n;
            bl = true;
        }
        if (dimension2.height - n < dimension.height) {
            dimension.height = dimension2.height - n;
            bl = true;
        }
        if (bl) {
            window.setSize(dimension);
        }
        Point point = window.getLocation();
        boolean bl2 = false;
        if (point.y + dimension.height > dimension2.height) {
            point.y = (dimension2.height - dimension.height) / 2;
            bl2 = true;
        }
        if (point.x + dimension.width > dimension2.width) {
            point.x = (dimension2.width - dimension.width) / 2;
            bl2 = true;
        }
        if (bl2) {
            window.setLocation(point);
        }
    }
}

