% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qc_missed_cleavages.R
\name{qc_missed_cleavages}
\alias{qc_missed_cleavages}
\title{Check missed cleavages}
\usage{
qc_missed_cleavages(
  data,
  sample,
  grouping,
  missed_cleavages,
  intensity,
  remove_na_intensities = TRUE,
  method = "count",
  plot = FALSE,
  interactive = FALSE
)
}
\arguments{
\item{data}{A data frame containing at least sample names, peptide or precursor identifiers and missed cleavage counts for each peptide or precursor.}

\item{sample}{the name of the column in the data data frame containing the sample name.}

\item{grouping}{the name of the column in the data data frame containing either precursor or peptide identifiers.}

\item{missed_cleavages}{the name of the column in the data data frame containing the counts of missed cleavages per peptide or precursor.}

\item{intensity}{the name of the column containing the corresponding raw or normalised intensity values (not log2) for each peptide or precursor. Required when "intensity" is chosen as the method.}

\item{remove_na_intensities}{Logical specifying if sample/grouping combinations with intensities that are NA (not quantified IDs) should
be dropped from the data frame for analysis of missed cleavages. Default is TRUE since we are usually
interested in quantifiable peptides. This is only relevant for method = "count".}

\item{method}{character vector indicating the method used for evaluation. "count" calculates the percentage of missed cleavages based on counts of the corresponding peptide or precursor, "intensity" calculates the percentage of missed cleavages by intensity of the corresponding peptide or precursor.}

\item{plot}{A logical indicating whether the result should be plotted.}

\item{interactive}{Argument specifying whether the plot should be interactive (default is FALSE).}
}
\value{
A data frame that contains the calculated percentage made up by the sum of all peptides or precursors containing the corresponding amount of missed cleavages.
}
\description{
Calculates the percentage of missed cleavages for each sample (by count or intensity).The default settings remove grouping variables without quantitative information (intensity is NA).
These will not be used for the calculation of missed cleavage percentages.
}
\examples{
\dontrun{
qc_missed_cleavages(
  data,
  sample = r_file_name,
  grouping = pep_stripped_sequence,
  missed_cleavages = pep_nr_of_missed_cleavages,
  intensity = fg_quantity,
  method = "intensity",
  plot = TRUE
)
}
}
