% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_cv.R
\name{filter_cv}
\alias{filter_cv}
\title{Data filtering based on coefficients of variation (CV)}
\usage{
filter_cv(
  data,
  grouping,
  condition,
  log2_intensity,
  cv_limit = 0.25,
  min_conditions,
  silent = FALSE
)
}
\arguments{
\item{data}{Data frame containing at least the input variables.}

\item{grouping}{Column in the data frame containing the grouping variable that can be either precursors, peptides or proteins.}

\item{condition}{Column in the data frame containing information on the sample condition.}

\item{log2_intensity}{Column in the data frame containing log2 transformed intensities.}

\item{cv_limit}{Optional argument specifying the CV cutoff that will be applied. Default is 0.25.}

\item{min_conditions}{The minimum number of conditions for which grouping CVs should be below the cutoff.}

\item{silent}{Logical argument specifiying if a message with the number of filtered out conditions should be returned.}
}
\value{
The CV filtered data frame.
}
\description{
Filters the input data based on precursor, peptide or protein intensity coefficients of variation.
The function should be used to ensure that only robust measurements and quantifications are used for
data analysis. It is advised to use the function after inspection of raw values (quality control) and
median normalisation. Generally, the function calculates CVs of each peptide, precursor or protein for
each condition and removes peptides, precursors or proteins that have a CV above the cutoff in less
than the (user-defined) required number of conditions. Since the user-defined cutoff is fixed and does not
depend on the number of conditions that have detected values, the function might bias for data completeness.
}
\examples{
\dontrun{
filter_cv(
  data,
  grouping = eg_precursor_id,
  condition = r_condition,
  log2_intensity = normalised_intensity_log2,
  cv_limit = 0.25,
  min_conditions = 5
)
}
}
