% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.teeMod.R
\name{summary.teeMod}
\alias{summary.teeMod}
\alias{print.summary.teeMod}
\title{Summarizing \code{teeMod} objects}
\usage{
\method{summary}{teeMod}(object, vcov.type = "HC0", ...)

\method{print}{summary.teeMod}(
  x,
  digits = max(3L, getOption("digits") - 3L),
  signif.stars = getOption("show.signif.stars"),
  ...
)
}
\arguments{
\item{object}{\code{teeMod} object}

\item{vcov.type}{A string indicating the desired variance estimator. See
\code{\link[=vcov_tee]{vcov_tee()}} for details on accepted types.}

\item{...}{Additional arguments to \code{\link[=vcov_tee]{vcov_tee()}}, such as the desired finite
sample heteroskedasticity-robust standard error adjustment.}

\item{x}{\code{summary.teeMod} object}

\item{digits}{the number of significant digits to use when printing.}

\item{signif.stars}{logical. If ‘TRUE’, ‘significance stars’ are printed for
each coefficient.}
}
\value{
object of class \code{summary.teeMod}
}
\description{
\code{\link[=summary]{summary()}} method for class \code{teeMod}
}
\details{
If a \code{teeMod} object is fit with a \code{SandwichLayer}
offset, then the usual \code{stats::summary.lm()} output is enhanced by
the use of covariance-adjusted sandwich standard errors, with t-test
values recalculated to reflect the new standard errors.
}
