% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CLASS_prolific_study.R,
%   R/METHODS_prolific_study.R, R/zzz.R
\docType{class}
\name{prolific_study}
\alias{prolific_study}
\alias{prolific_study-class}
\alias{completion_code}
\alias{completion_code<-}
\alias{completion_option}
\alias{completion_option<-}
\alias{description}
\alias{description<-}
\alias{device_compatibility}
\alias{device_compatibility<-}
\alias{eligibility_requirements-field}
\alias{eligibility_requirements<-}
\alias{estimated_completion_time}
\alias{estimated_completion_time<-}
\alias{external_study_url}
\alias{external_study_url<-}
\alias{further_fields}
\alias{further_fields<-}
\alias{id}
\alias{id<-}
\alias{internal_name}
\alias{internal_name<-}
\alias{maximum_allowed_time}
\alias{maximum_allowed_time<-}
\alias{naivety_distribution_rate}
\alias{naivety_distribution_rate<-}
\alias{name}
\alias{name<-}
\alias{peripheral_requirements}
\alias{peripheral_requirements<-}
\alias{project}
\alias{project<-}
\alias{prolific_id_option}
\alias{prolific_id_option<-}
\alias{reward}
\alias{reward<-}
\alias{total_available_places}
\alias{total_available_places<-}
\alias{url_parameters}
\alias{url_parameters<-}
\alias{validity_check-prolific_study}
\title{Prolific study}
\description{
Class that represents Prolific studies, such that they can be transferred to or from the \href{https://docs.prolific.co/docs/api-docs/public/}{Prolific API}.
This allows to create, review and update studies.\cr
\emph{The fields and methods are available as in RefClass or S4 objects (see examples and the \href{../doc/prolificapi-package.html}{prolific.api package vignette}).}

API access to interact with the Prolific platform is done by using objects from the \code{\link[=api_access]{api_access class}}, i.e.
\code{\link[=prolific_study]{prolific_studies}} are intended to be transferred as bodies in calls to the \href{https://docs.prolific.co/docs/api-docs/public/}{Prolific API} (see examples).
}
\section{Fields}{

\describe{
\item{\code{id}}{(\code{\link[=character]{character}}):\cr
The study's ID on Prolific.\cr
\strong{Note: This ID is set by Prolific and can not be changed by the user}\cr (see the '\emph{Further (read-only) fields}' section below).}

\item{\code{name}}{(\code{\link[=character]{character}}):\cr
Public name or title of the study \emph{(will be publicly visible when publishing the study).}}

\item{\code{internal_name}}{(\code{\link[=character]{character}}):\cr
Internal name of the study \emph{(not shown to participants)}.}

\item{\code{description}}{(\code{\link[=character]{character}}):\cr
Description of the study \emph{(will be publicly visible when publishing the study).}}

\item{\code{external_study_url}}{(\code{\link[=character]{character}}):\cr
URL of the survey or experiment the participants will be redirected to \emph{(will be publicly visible when publishing the study).}\cr
\strong{Note:}
\itemize{
\item{The URL must be valid at the time the study is created on the Prolific platform.}
\item{For the use of URL parameters, see field \code{url_parameters}.}
}}

\item{\code{url_parameters}}{(\code{\link[=list]{list}}):\cr
A named list of URL parameters that is appended to \code{external_study_url}.
The default
\preformatted{list(
     prolific_id = "{\%PROLIFIC_PID\%}",
     study_id = "{\%STUDY_ID\%}",
     session_id = "{\%SESSION_ID\%}"
)
}
is used for passing the participant's, study's and session's ID from Prolific to the data collection website.}

\item{\code{prolific_id_option}}{(\code{\link[=character]{character}}):\cr
This determines the method of passing the respondent's Prolific ID.\cr
\strong{Valid options are:}
\itemize{
\item{\code{"url_parameters"} }{for passing the ID as URL parameter \code{{\%PROLIFIC_PID\%}}}
\item{\code{"question"} }{for letting the respondents enter their ID (e.g. via copy & paste), or}
\item{\code{"not_required"} }{if the Prolific ID is not to be passed.}
}}

\item{\code{completion_code}}{(\code{\link[=character]{character}}):\cr
The completion code that is provided to participants after completing the study.
This code is used to prove that a participant completed the study.
It is therefore \emph{visible for participants after completing the study.}}

\item{\code{completion_option}}{(\code{\link[=character]{character}}):\cr
This determines the method for passing the \code{completion_code}.\cr
\strong{Valid options are:}
\itemize{
\item{\code{"url"}}{for passing the code as URL parameter when redirecting participants back to Prolific after completing the study, or}
\item{\code{"code"}}{for providing a code for copy and paste.}
}}

\item{\code{total_available_places}}{(\code{\link[=integer]{integer}}):\cr
The number of participant you would like to recruit
in the study \emph{(will be publicly visible when publishing the study).}}

\item{\code{estimated_completion_time}}{(\code{\link[=integer]{integer}}):\cr
The estimated time it takes to complete the study, \emph{in minutes} \emph{(will be publicly visible when publishing the study).}}

\item{\code{maximum_allowed_time}}{(\code{\link[=integer]{integer}}):\cr
The maximum allowed time for participants to complete the study, \emph{in minutes}.}

\item{\code{reward}}{(\code{\link[=integer]{integer}}):\cr
The amount of money (in pence)
you pay for completing the study \emph{(will be publicly visible when publishing the study).}\cr
\strong{Note:} Compensation...}

\item{\code{eligibility_requirements}}{(\code{\link[=list]{list}}):\cr
A list containing \code{\link[=prolific_prescreener]{prolific_prescreener objects}} that characterize the participants to be recruited.
\strong{Note:}
\itemize{
\item{\code{\link[=NULL]{NULL}} means that every participant can see and complete the study.}{}
\item{\strong{Only persons fulfiling these requirements will be able to participate in the study.}}{}
}}

\item{\code{device_compatibility}}{(\code{\link[=character]{character}}):\cr
\strong{Note:} \code{\link[=NULL]{NULL}} means that all options are available.}

\item{\code{peripheral_requirements}}{(\code{\link[=character]{character}}):\cr
A vector of technical requirements that participants have to fulfill to complete the study.
One or multiple values from
\preformatted{   c("audio", "camera", "download", "microphone")}
\strong{Note:} \code{\link[=NULL]{NULL}} means that none of the requirements is needed.}

\item{\code{naivety_distribution_rate}}{(\code{\link[=numeric]{numeric}}):\cr
A value between \code{1} and \code{0} that controls the balance between speed of your study and the naivety of the participants.\cr
Prolific's description of this field is rather vague, but it seems to imply that
\itemize{
\item{\code{1} }{means that less trained or 'professional' participants will have access to the study.}
\item{\code{0} }{means that all eligible participants will have access to the study at the same time.}
\item{\code{values between 0 and 1} }{represent a tradeoff between both options.}
}}

\item{\code{further_fields}}{(\code{\link[=list]{list}}):\cr
Prolific studies can have various further fields, which (if used) are stored in \code{\link[=prolific_study]{further_fields}}.
These fields are read-only,  and determined by Prolific.
See the '\emph{Further (read-only) fields}' section below for a list of these read-only fields.}

\item{\code{\dots}}{(\link[=dots]{further arguments}):\cr
Will be added to the \code{\link[=prolific_study]{further_fields}} field of the \code{\link[=prolific_study]{prolific_study}}
(see above).}
}}


\section{Types of fields}{
\describe{
\item{Required fields}{
are required for creating a study on Prolific.\cr
\strong{The values for all of these except \code{completion_option} and \code{prolific_id_option} should be specified before publishing a study. Default values are only placeholders.}
}
}
\describe{
\item{Optional fields}{
are writable, but optional for Prolific.\cr
The user can but does not have to set these fields when creating a study.\cr
The required and optional fields are:
}
}
\tabular{lll}{
\verb{           }\tab \strong{Required fields}		\tab	\strong{Optional fields}		\cr
\tab \code{completion_code}		\tab	\code{device_compatibility}		\cr
\tab \code{completion_option}		\tab	\code{internal_name}		\cr
\tab \code{description}		\tab	\code{maximum_allowed_time}		\cr
\tab \code{eligibility_requirements}		\tab	\code{naivety_distribution_rate}		\cr
\tab \code{estimated_completion_time}		\tab	\code{peripheral_requirements}		\cr
\tab \code{external_study_url}		\tab	\code{url_parameters}		\cr
\tab \code{name}				\cr
\tab \code{prolific_id_option}				\cr
\tab \code{reward}				\cr
\tab \code{total_available_places}				\cr
}

\describe{
\item{Further (read-only) fields}{
contain information that is determined internally by Prolific and read-only.\cr
The \code{id}-field
is of particular relevance.
Once a study is created via \href{https://docs.prolific.co/docs/api-docs/public/}{API} access, it is \strong{obtained from the \href{https://docs.prolific.co/docs/api-docs/public/}{API} and
stored in the \code{prolific_study} object}, since it can be used to update, manage or delete a study.\cr
To fully represent the information that is obtainable from the \href{https://docs.prolific.co/docs/api-docs/public/}{Prolific API},
the \code{further_fields} list can contain some or all of the entries listed below.
The corresponding overview provided in the
\href{https://docs.prolific.co/docs/api-docs/public/#tag/Studies/paths/~1api~1v1~1studies~1\%7Bid\%7D~1/get}{Prolific API documentation}
currently seems to be work in progress.
}
}
\tabular{lll}{
\verb{           } \tab \code{_links }	\tab	\code{average_reward_per_hour}			\cr
\tab \code{average_reward_per_hour_without_adjustment}	\tab	\code{average_time_taken}			\cr
\tab \code{currency_code}	\tab	\code{date_created}			\cr
\tab \code{device_compatibility}	\tab	\code{discount_from_coupons}			\cr
\tab \code{eligible_participant_count}	\tab	\code{estimated_reward_per_hour}			\cr
\tab \code{fees_per_submission}	\tab	\code{fees_percentage}			\cr
\tab \code{has_had_adjustment}	\tab	\code{internal_name}			\cr
\tab \code{is_pilot}	\tab	\code{is_underpaying}			\cr
\tab \code{last_email_update_sent_datetime}	\tab	\code{maximum_allowed_time}			\cr
\tab \code{minimum_reward_per_hour}	\tab	\code{naivety_distribution_rate}			\cr
\tab \code{number_of_submissions}	\tab	\code{peripheral_requirements}			\cr
\tab \code{pilot_test_steps_state}	\tab	\code{places_taken}			\cr
\tab \code{project}	\tab	\code{publish_at}			\cr
\tab \code{published_at}	\tab	\code{publisher}			\cr
\tab \code{quota_requirements}	\tab	\code{receipt}			\cr
\tab \code{representative_sample}	\tab	\code{representative_sample_fee}			\cr
\tab \code{researcher}	\tab	\code{reward_level}			\cr
\tab \code{share_id}	\tab	\code{stars_remaining}			\cr
\tab \code{status}	\tab	\code{study_type}			\cr
\tab \code{total_cost}	\tab	\code{total_participant_pool}			\cr
\tab \code{vat_percentage}	\tab	\code{workspace}			\cr
}
}

\section{Methods}{

\subsection{\code{validity_check}}{

Check whether the study is valid in terms of the \href{https://docs.prolific.co/docs/api-docs/public/}{Prolific API}.\cr
\strong{Note:} For checking the validity of the \code{\link[=prolific_study]{eligibility_requirements}},
an \code{\link[=api_access]{api_access object}} that passes \code{\link[=api_access]{check_authorization()}} needs to be available.
It suffices if any such \code{\link[=api_access]{api_access object}} is specified, since the reference to it is determined automatically.
\subsection{\strong{Return Value}}{

\itemize{
\item{If the study is valid: }{A \code{\link[=logical]{logical}} value indicating that the study is valid}
\item{If the study is not valid: }{A \code{\link[=character]{character}} vector that lists the studie's issues.}
}
}

\subsection{\strong{Usage}}{

\preformatted{
     prolific_study$validity_check()
}
}

}
}

\examples{
library(prolific.api)

prolific_api_access <- api_access(api_token = "<api_token>")

# Create a new study
fancy_new_study <- prolific_study(
    name = "A fancy study on Prolific",
    external_study_url = "https://www.my_fancy_study_url.com",
    completion_code = "123ab456cd78",
    eligibility_requirements = list(),
    estimated_completion_time = 1,
    reward = 1,
    total_available_places = 0
)

# Check the study's validity
print(fancy_new_study$validity_check())

# Whoops, better add a description and change the total_available_places,
# using RefClass and S4 methods for illustration
# both are equivalent, so only one of the two commands is required in practice
# RefClass variant
fancy_new_study$total_available_places <- 1L
# S4 variant
total_available_places(fancy_new_study) <- 1L

# RefClass variant
fancy_new_study$description <- "A fancy description"
# S4 variant
description(fancy_new_study) <- "A fancy description"

# Re-Check the study's validity
print(fancy_new_study$validity_check())

# Note: For the following code to work,
# you have to replace <api_token> in the code above by the actual API token

\dontrun{
# Post the 'fancy_new_study' to Prolific - i.e. create it as a draft study on the platform
output_of_post <- prolific_api_access$access(
    endpoint = "studies",
    method = "post",
    data = fancy_new_study
)

# Success: fancy_new_study got an ID - it is now a draft study on Prolific!
fancy_new_study$id

# Note: The output of the access() command with a prolific_study object as `data` argument
# is a pointer to this prolific_study object.
# The prolific_study object is updated by reference
print(tracemem(output_of_post) == tracemem(fancy_new_study))

# Change the study's name
name(fancy_new_study) <- "A NEW name for 'fancy_new_study'"

# Update (patch) the study on Prolific,
# using S4 methods for illustration
output_of_patch <- access(
    prolific_api_access,
    endpoint = c("studies", id(fancy_new_study)),
    method = "patch",
    data = fancy_new_study
)

# Note: As above, the output of the access() command is a pointer to the prolific_study object.
print(tracemem(output_of_post) == tracemem(fancy_new_study))

# Delete fancy_new_study
prolific_api_access$access(
    endpoint = c("studies", id(fancy_new_study)),
    method = "delete",
    as_list = FALSE
)
}
}
