% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse.R
\name{parse_issue_comments}
\alias{parse_issue_comments}
\title{Parse issue comments from \code{get_issues_comments}}
\usage{
parse_issue_comments(res)
}
\arguments{
\item{res}{List returned by corresponding \code{get_} function}
}
\value{
Dataframe with one record / issue-comment
}
\description{
Parse issue comments from \code{get_issues_comments}
}
\examples{
\dontrun{
myrepo <- create_repo_ref('emilyriederer', 'myrepo')
comments_res <- get_issue_comments(myrepo, number = 1)
comments <- parse_issue_comments(comments_res)
}
}
\seealso{
Other issues: \code{\link{get_issue_comments}},
  \code{\link{get_issue_events}}, \code{\link{get_issues}},
  \code{\link{parse_issue_events}},
  \code{\link{parse_issues}}, \code{\link{post_issue}},
  \code{\link{report_discussion}},
  \code{\link{report_progress}},
  \code{\link{viz_waterfall}}

Other comments: \code{\link{get_issue_comments}},
  \code{\link{report_discussion}}
}
\concept{comments}
\concept{issues}
