% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/file_management.R
\name{file_management}
\alias{file_management}
\alias{new_project_group}
\alias{move_project}
\alias{copy_project}
\alias{archive_project}
\alias{open_project}
\title{file management}
\usage{
new_project_group(path)

move_project(project, path, make_directories = FALSE, archived = FALSE)

copy_project(project_to_copy, path, new_id = NA,
  make_directories = FALSE, archived = FALSE)

archive_project(project)

open_project(project, new_session = FALSE, archived = FALSE)
}
\arguments{
\item{path}{A valid path string. See the \code{path} argument in
\code{\link{new_project}()} for details, the one difference being that
there is no default (i.e., the user cannot leave \code{path} blank in these
functions).}

\item{project}{Project \code{id} or unambiguous substring of the project name
from the \code{\link{projects}()} tibble.}

\item{make_directories}{Logical. If the path represented by the \code{path}
parameter does not exist, should the needed directories be created?}

\item{archived}{Logical indicating whether or not the function should
  consider archived projects when determining which project the user is
  referring to in the \code{project}/\code{project_to_copy} argument.
  \code{FALSE} by default.

  See the \strong{Details} section of \code{\link{archive_project}()} for
  more information on the "archived" status of a project.}

\item{project_to_copy}{Project \code{id} or unambiguous substring of the
project name corresponding to the project that is to be copied.}

\item{new_id}{Optional integer, ranging from 1 to 9999, used as the
newly-created project ID. Must not already exist in
\code{\link{projects}()$id}. If left blank, the lowest available \code{id}
will be automatically used.}

\item{new_session}{Same as the \code{newSession} argument in
\code{rstudio::\link[rstudioapi]{openProject}()}.}
}
\description{
Tools for Organizing and Managing Project Files
}
\details{
Projects can be moved (\code{move_project()}), copied
(\code{copy_project()}), deleted (\code{\link{delete_project}()}) or archived
(\code{archive_project}).

The difference between \code{delete_project()} and \code{archive_project()}
is that the latter will just move the project to a directory called
\emph{archive}, located in the same parent directory as the project. This
directory gets created if it doesn't yet exist. Some functions that perform
actions on projects will exclude archived projects by default in order to
make it easier for the user to enter a nonambiguous string that will match an
active (i.e., non-archived) project.

Projects can also be organized into groups. By default, all projects are
created within the main \code{\link{projects_folder}}. To create a project
group, which essentially is a subfolder of projects that sits within the main
\code{\link{projects_folder}} (or recursively within another project group's
folder), use \code{new_project_group()}.

\code{open_project()} is a wrapper around
\code{\link[rstudioapi]{openProject}}, but the user only needs to know the
project's \code{id}, \code{title}, or \code{short_title} instead of the file
path of the project's \emph{.Rproj} file.
}
\examples{
# SETUP
old_path <- Sys.getenv("PROJECTS_FOLDER_PATH")
setup_projects(path = tempdir(), .Renviron_path = fs::path_temp(".Renviron"))
#############################################################################

# setting up a simple project directory tree
new_project_group("kidney/clinical")
new_project_group("kidney/genomics")
new_project_group("prostate/clinical")
new_project_group("prostate/genomics")

# Wrapped in if(interactive()) because it requires interactive console input
# and fails automated package checking and testing.
if(interactive()){
  new_project(title = "Sample Authorless Project", path = "kidney")

  # Moving the project folder, then moving it again.
  move_project(project = 1, "kidney/genomics")
  move_project(project = "Sample Authorless Project", "prostate/clinical")

  # Copying the project
  copy_project(project_to_copy = 1, "kidney/clinical")

  # Archiving the copy of the project
  archive_project(2)

  # Opens the project in same session
  open_project("Sample")

  # Opens the project in a new session
  open_project(1, new_session = TRUE)
}
#############################################################################
# CLEANUP
Sys.setenv(PROJECTS_FOLDER_PATH = old_path)
fs::file_delete(c(fs::path_temp("projects"), fs::path_temp(".Renviron")))
}
\seealso{
\code{\link{new_project}()} and \code{\link{delete_project}()} for
  other functions that write and delete files
}
