% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/withProgressShiny.R
\name{withProgressShiny}
\alias{withProgressShiny}
\title{Use Progressr in Shiny Apps: Plug-in Backward Compatibility Replacement for shiny::withProgress()}
\usage{
withProgressShiny(
  expr,
  ...,
  env = parent.frame(),
  quoted = FALSE,
  handlers = c(shiny = handler_shiny, progressr::handlers(default = NULL))
)
}
\arguments{
\item{expr, \ldots, env, quoted}{Arguments passed to \link[shiny:withProgress]{shiny::withProgress} as is.}

\item{handlers}{Zero or more progression handlers used to report on progress.}
}
\value{
The value of \link[shiny:withProgress]{shiny::withProgress}.
}
\description{
Use Progressr in Shiny Apps: Plug-in Backward Compatibility Replacement for shiny::withProgress()
}
\section{Requirements}{

This function requires the \pkg{shiny} package.
}

\examples{
library(shiny)
library(progressr)

app <- shinyApp(
  ui = fluidPage(
    plotOutput("plot")
  ),

  server = function(input, output) {
    output$plot <- renderPlot({
      X <- 1:15
      withProgressShiny(message = "Calculation in progress",
                        detail = "This may take a while ...", value = 0, {
        p <- progressor(along = X)
        y <- lapply(X, FUN=function(x) {
          p()
          Sys.sleep(0.25)
        })
      })
      
      plot(cars)

      ## Terminate the Shiny app
      Sys.sleep(1.0)
      stopApp(returnValue = invisible())
    })
  }
)

local({
  oopts <- options(device.ask.default = FALSE)
  on.exit(options(oopts))
  if (interactive()) print(app)
})
}
