% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ScalarParameter-proto.R
\name{ScalarParameter-class}
\alias{ScalarParameter-class}
\alias{ScalarParameter}
\title{Scalar parameter prototype}
\description{
This prototype is used to represent a parameter has a single value.
\strong{Only experts should interact directly with this prototype.}
}
\section{Fields}{

\describe{

\item{$id}{\code{character} identifier for parameter.}

\item{$name}{\code{character} name of parameter.}

\item{$value}{\code{numeric} scalar value.}

\item{$default}{\code{numeric} scalar default value.}

\item{$class}{\code{character} name of the class that \verb{$value} should
inherit from (e.g. \code{integer}).}

\item{$lower_limit}{\code{numeric} scalar value that is the minimum value
that \verb{$value} is permitted to be.}

\item{$upper_limit}{\code{numeric} scalar value that is the maximum value
that \verb{$value} is permitted to be.}

}
}

\section{Usage}{


\code{x$print()}

\code{x$show()}

\code{x$validate(x)}

\code{x$get()}

\code{x$set(x)}

\code{x$reset()}
}

\section{Arguments}{


\describe{

\item{x}{object used to set a new parameter value.}

}
}

\section{Details}{

\describe{

\item{print}{print the object.}

\item{show}{show the object.}

\item{validate}{check if a proposed new set of parameters are valid.}

\item{get}{extract the parameter value.}

\item{set}{update the parameter value.}

\item{reset}{update the parameter value to be the default value.}

}
}

\seealso{
\code{\linkS4class{Parameter}}, \code{\linkS4class{ArrayParameter}}.
}
