% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/marxan_boundary_data_to_matrix.R
\name{marxan_boundary_data_to_matrix}
\alias{marxan_boundary_data_to_matrix}
\title{Convert \emph{Marxan} boundary data to a matrix format}
\usage{
marxan_boundary_data_to_matrix(x, data)
}
\arguments{
\item{x}{\code{\link{ConservationProblem-class}} object that contains
planning unit and zone data to ensure that the argument to
\code{data} is converted correctly. This argument can be set to
\code{NULL} if checks are not required (not recommended).}

\item{data}{\code{data.frame} object with the columns \code{"id1"},
\code{"id2"}, and \code{"boundary"}. The columns \code{"zone1"} and
\code{"zone2"} can also be provided to indicate zone data.}
}
\value{
\code{array} or sparse matrix (\code{\link{dgCMatrix-class}}) object.
}
\description{
Convert a \code{data.frame} object that follows the \emph{Marxan} format
to a matrix format. This function is useful for converting
\code{data.frame} objects to \code{matrix} or \code{array} objects that
are used by the various \code{\link{penalties}} and
\code{\link{constraints}} functions. If the boundary data contains data for
a single zone, then a matrix object is returned. Otherwise if the boundary
data contains data for multiple zones, then an array is returned.
}
\examples{
# create marxan boundary with four planning units and one zone
bldf1 <- expand.grid(id1 = seq_len(4), id2 = seq_len(4))
bldf1$boundary <- 1
bldf1$boundary[bldf1$id1 == bldf1$id2] <- 0.5

# convert to matrix
m1 <- marxan_boundary_data_to_matrix(NULL, bldf1)

# visualize matrix
image(m1)

# create marxan boundary with three planning units and two zones
bldf2 <- expand.grid(id1 = seq_len(3), id2 = seq_len(3),
                     zone1 = c("z1", "z2"),
                     zone2 = c("z1", "z2"))
bldf2$boundary <- 1
bldf2$boundary[bldf2$id1 == bldf2$id2 & bldf2$zone1 == bldf2$zone2] <- 0.5
bldf2$boundary[bldf2$id1 == bldf2$id2 & bldf2$zone1 != bldf2$zone2] <- 0

# convert to array
m2 <- marxan_boundary_data_to_matrix(NULL, bldf2)

# print array
print(m2)
}
