% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_lpsymphony_solver.R
\name{add_lsymphony_solver}
\alias{add_lsymphony_solver}
\alias{add_lpsymphony_solver}
\title{Add a SYMPHONY solver with \pkg{lpsymphony}}
\usage{
add_lpsymphony_solver(x, gap = 0.1, time_limit = -1, first_feasible = 0,
  verbose = TRUE)
}
\arguments{
\item{x}{\code{\link{ConservationProblem-class}} object.}

\item{gap}{\code{numeric} gap to optimality. This gap is absolute and
expresses the acceptable deviance from the optimal objective. For example,
solving a minimum set objective problem with a gap of 5 will cause the
solver to terminate when the cost of the solution is within 5 cost units
from the optimal solution.}

\item{time_limit}{\code{numeric} time limit in seconds to run the optimizer.
The solver will return the current best solution when this time limit is
exceeded.}

\item{first_feasible}{\code{logical} should the first feasible solution be
be returned? If \code{first_feasible} is set to \code{TRUE}, the solver
will return the first solution it encounters that meets all the
constraints, regardless of solution quality. Note that the first feasible
solution is not an arbitrary solution, rather it is derived from the
relaxed solution, and is therefore often reasonably close to optimality.}

\item{verbose}{\code{logical} should information be printed while solving
optimization problems? Defaults to \code{TRUE}.}
}
\value{
\code{\link{ConservationProblem-class}} object with the solver added
  to it.
}
\description{
Specify that the \emph{SYMPHONY} software should be used to solve a
conservation planning problem using the \pkg{lpsymhpony} package. This
function can also be used to customize the behavior of the solver.
It requires the \pkg{lpsymphony} package.
}
\details{
\href{https://projects.coin-or.org/SYMPHONY}{\emph{SYMPHONY}} is an
  open-source integer programming solver that is part of the Computational
  Infrastructure for Operations Research (COIN-OR) project, an initiative
  to promote development of open-source tools for operations research (a
  field that includes linear programming). The \pkg{lpsymphony} package is
  distributed through
  \href{https://doi.org/doi:10.18129/B9.bioc.lpsymphony}{Bioconductor}.
  This functionality is provided because the \pkg{lpsymphony} package may
  be easier to install to install on Windows and Mac OSX systems than the
  \pkg{Rsymphony} package.
}
\examples{
# load data
data(sim_pu_raster, sim_features)

# create problem
p <- problem(sim_pu_raster, sim_features) \%>\%
  add_min_set_objective() \%>\%
  add_relative_targets(0.1) \%>\%
  add_binary_decisions()
\donttest{
# if the package is installed then add solver and generate solution
# note that this solver is skipped on Linux systems due to the fact
# that the lpsymphony package randomly crashes on these systems
if (require(lpsymphony) &
    isTRUE(Sys.info()[["sysname"]] != "Linux")) {
  # specify solver and generate solution
  s <- p \%>\% add_lpsymphony_solver(time_limit = 5) \%>\%
             solve()

  # plot solutions
  plot(stack(sim_pu_raster, s), main = c("planning units", "solution"))
}
}

}
\seealso{
\code{\link{solvers}}.
}
