% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/solution-summary.r
\name{solution_summary}
\alias{solution_summary}
\title{Summarize results of prioritization exercise}
\usage{
solution_summary(model, results)
}
\arguments{
\item{model}{\code{prioritizr_model} object}

\item{results}{\code{prioritizr_results} object}
}
\value{
A list containing the number of planning units (\code{n_pu}), total
  cost (\code{cost}), representation level of each feature
  (\code{amount_held}), and whether or not each target was achieved, for the
  prioritization solution.
}
\description{
Summarize results of prioritization exercise
}
\examples{
\dontrun{
# raster 100x100 template
e <- raster::extent(0, 100, 0, 100)
r <- raster::raster(e, nrows = 100, ncols = 100, vals = 1)

# generate 9 feature distributions with different scales and range sizes
f <- mapply(function(x, y, r) gaussian_field(r = r, range = x, prop = y),
            rep(c(5, 15, 25), each = 3),
            rep(c(0.1, 0.25, 0.5), times = 3),
            MoreArgs = list(r = r))
f <- raster::stack(f)
f <- setNames(f, letters[1:raster::nlayers(f)])
# genrate cost layer
cost <- gaussian_field(r, 20, mean = 1000, variance = 500)
cost <- setNames(cost, "cost")

# prepare minimum set cover prioritization model
# use 20\% targets
msc_model <- minsetcover_model(x = cost, features = f, targets = 0.2)

# solve
msc_results <- prioritize(msc_model)
summary(msc_model, msc_results)
}
}

