% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_selection.r
\name{plot_selection}
\alias{plot_selection}
\title{Plot selected planning units}
\usage{
plot_selection(pu, x, title, colours, axes, ...)
}
\arguments{
\item{pu}{RasterLayer of SpatialPolygons object of planning units.}

\item{x}{binary or logical vector; decision variables indicating whether
planning units are selected or not selected. The order of the decision
variables should match the order of planning units in \code{pu}.}

\item{title}{character; plot title.}

\item{colours}{character; vector of two colours to display unselected and
selected planning units, respectively.}

\item{axes}{logical; whether or not to show axes.}

\item{...}{additional arguments to pass to \code{\link[rasterVis]{levelplot}}
or \code{\link[sp]{spplot}}.}
}
\value{
\code{plot_selection} returns a lattice plot of class \code{trellis},
  if you fail to see it explicity call \code{print(plot_selection(...))}.
}
\description{
This function is a wrapper for \code{\link[rasterVis]{levelplot}} (for raster
planning units) and \code{\link[sp]{spplot}} (for vector planning units).
}
\examples{
\dontrun{
# raster planning units
e <- raster::extent(0, 100, 0, 100)
pu_raster <- raster::raster(e, nrows = 100, ncols = 100, vals = 1)
x_selected <- as.vector(gaussian_field(pu_raster, 20, prop = 0.25)[])
plot_selection(pu_raster, x_selected)

# vector planning units
pu_spdf <- raster::rasterToPolygons(pu_raster)
plot_selection(pu_spdf, x_selected)
}
}

