% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/solve.R
\name{solve}
\alias{solve}
\title{Solve mathematical models}
\usage{
solve(
  a,
  solver = "",
  gap_limit = 0,
  time_limit = .Machine$integer.max,
  solution_limit = FALSE,
  cores = 2,
  verbose = TRUE,
  name_output_file = "output",
  output_file = TRUE
)
}
\arguments{
\item{a}{\linkS4class{optimizationProblem} object. Optimization model created
for the problem of prioritization of multiple conservation actions. This object must be
created using the \code{problem()} function.}

\item{solver}{\code{string}. Name of solver to use to
solve the model. The following solvers are supported:
\href{https://www.gurobi.com/}{\code{"gurobi"}}(requires the \pkg{gurobi} package),
\href{https://www.ibm.com/es-es/products/ilog-cplex-optimization-studio}{\code{"cplex"}}(requires the \pkg{Rcplex} package) and
\href{https://github.com/coin-or/SYMPHONY}{\code{"symphony"}}(requires the \pkg{Rsymphony} package).
We recommend using gurobi (for more information on how to obtain an academic license
\href{https://prioritizr.net/articles/gurobi_installation_guide.html}{here}).}

\item{gap_limit}{\code{numeric}. Value between 0 and 1 that represents the gap
to optimality, i.e., a relative number that cause the optimizer to
terminate when the difference between the upper and lower objective
function bounds is less than the gap times the upper bound. For example, a
value of 0.01 will result in the optimizer stopping when the difference
between the bounds is 1 percent of the upper bound. Default is 0.0.}

\item{time_limit}{\code{numeric}. Time limit to run the optimizer (in seconds).
The solver will return the current best solution when this time limit is exceeded.
Default is the maximum integer number of your machine.}

\item{solution_limit}{\code{logical}. Indicates if the solution process
should be stopped after the first feasible solution is found (\code{TRUE}),
or not (\code{FALSE}).}

\item{cores}{\code{integer}. Number of parallel cores to use in the machine to solve the problem.}

\item{verbose}{\code{logical}. Indicates if the solver information is displayed while
solving the optimization model (\code{TRUE}), or if it is not displayed (\code{FALSE}).}

\item{name_output_file}{\code{string}. Prefix of all output names.}

\item{output_file}{\code{logical}. Indicates if the outputs are exported as .csv files (\code{TRUE}),
or they are not exported (\code{FALSE}). Currently, 5 files are exported. The
distribution of actions in the solution, the distribution of the selected
planning units, the benefits achieved by the features, the parameters used,
and the optimization engine log.}
}
\value{
An object of class \linkS4class{solution}.
}
\description{
Solves the optimization model associated with the multi-action
conservation planning problem. This function is used to solve
the mathematical model created by the \code{problem()} function.
}
\details{
The solvers supported by the \code{\link[=solve]{solve()}} function are
described below. \describe{

\item{\verb{Gurobi solver}}{ \href{https://www.gurobi.com/}{\emph{Gurobi}} is a
state-of-the-art commercial optimization software with an R package
interface. It is by far the fastest of the solvers available in this
package, however, also this solver is not freely available.
That said, licenses are available to academics at no cost. The \pkg{gurobi}
package is distributed with the \emph{Gurobi} software suite. This solver
uses the \pkg{gurobi} package to solve problems.}

\item{\verb{CPLEX solver}}{
\href{https://www.ibm.com/es-es/products/ilog-cplex-optimization-studio}{\emph{cplex}} is a
state-of-the-art commercial optimization software with an R package
interface. Like Gurobi, it is not freely accessible, but we can obtain academic
licenses. We recommend using this solver if the Gurobi solver is not available.
Licenses are available for the IBM CPLEX software to academics at no cost
\href{https://www.ibm.com/products/ilog-cplex-optimization-studio}{here}. This solver uses the
\pkg{Rcplex} package to solve problems.}

\item{\verb{Symphony solver}}{
\href{https://github.com/coin-or/SYMPHONY}{\emph{SYMPHONY}} is an
open-source integer programming solver that is part of the Computational
Infrastructure for Operations Research (COIN-OR) project, an initiative to
promote development of open-source tools for operations research (a field
that includes linear programming). The \pkg{Rsymphony} package provides an
interface to COIN-OR and is available on CRAN. This solver uses the
\pkg{Rsymphony} package to solve problems.}}
}
\examples{
\dontrun{
## This example uses input files included into package.

## Load data
data(sim_pu_data, sim_features_data, sim_dist_features_data,
sim_threats_data, sim_dist_threats_data, sim_sensitivity_data,
sim_boundary_data)

## Create data instance
problem_data <- inputData(
  pu = sim_pu_data, features = sim_features_data, dist_features = sim_dist_features_data,
  threats = sim_threats_data, dist_threats = sim_dist_threats_data,
  sensitivity = sim_sensitivity_data, boundary = sim_boundary_data
)

## Create optimization model
problem_model <- problem(x = problem_data, blm = 1)

## Solve the optimization model using a gap_limit and gurobi solver
## NOTE: The Gurobi solver must be previously installed and must have a valid license!
s1 <- solve(a = problem_model, solver = "gurobi", gap_limit = 0.01, output_file = FALSE, cores = 2)

print(s1)

## Solve the optimization model using a gap_limit and symphony solver
s2 <- solve(a = problem_model,
            solver = "symphony",
            gap_limit = 0.01,
            output_file = FALSE,
            cores = 2)

print(s2)

## Solve the optimization model using a time_limit and gurobi solver
s3 <- solve(a = problem_model, solver = "gurobi", time_limit = 10, output_file = FALSE, cores = 2)

print(s3)
}
}
\seealso{
For more information on how to install and obtain an academic
license of the Gurobi solver, see the \emph{Gurobi installation guide},
which can be found online at
\href{https://prioritizr.net/articles/gurobi_installation_guide.html}{prioritizr vignette}.
Just like Gurobi, cplex needs an academic licence to work. Details about how to install
the cplex solver, see the \href{https://www.ibm.com/products/ilog-cplex-optimization-studio}{webpage IBM CPLEX}.
Once installed, see the \emph{\pkg{Rcplex} installation guide}, which can be found online at
\href{https://github.com/cran/Rcplex/blob/master/inst/INSTALL}{Rcplex package}.
}
