% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/project_to_curve.R
\name{project_to_curve}
\alias{project_to_curve}
\title{Project a set of points to the closest point on a curve}
\usage{
project_to_curve(x, s, ord = seq_len(nrow(s)), stretch = 2)
}
\arguments{
\item{x}{a matrix of data points.}

\item{s}{a parametrized curve, represented by a polygon.}

\item{ord}{the order of the point in \code{s}. Default is the given order.}

\item{stretch}{A stretch factor for the endpoints of the curve; a maximum of 2.
it allows the curve to grow, if required, and helps avoid bunching at the end.}
}
\value{
A structure is returned which represents a fitted curve.  It has components
  \item{s}{The fitted points on the curve corresponding to each point \code{x}}
  \item{ord}{the order of the fitted points}
  \item{lambda}{The projection index for each point}
  \item{dist}{The total squared distance from the curve}
  \item{dist_ind}{The squared distances from the curve to each of the respective points}
}
\description{
Finds the projection index for a matrix of points \code{x}, when
projected onto a curve \code{s}. The curve need not be of the same
length as the number of points. If the points on the curve are not in
order, this order needs to be given as well, in \code{ord}.
}
\seealso{
\code{\link{principal_curve}}
}
\keyword{nonparametric}
\keyword{regression}
\keyword{smooth}
