% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{pcd_dist_name}
\alias{pcd_dist_name}
\title{Get distribution function cdf or pdf name}
\usage{
pcd_dist_name(name, type = c("delay", "primary"))
}
\arguments{
\item{name}{String. Distribution name or alias}

\item{type}{String. "delay" or "primary" corresponding to the type of
distribution to use as the look up. If delay then \code{\link[=pcd_distributions]{pcd_distributions()}}
is used, if primary then \code{\link[=pcd_primary_distributions]{pcd_primary_distributions()}} is used.}
}
\value{
String distribution function name or NA if no base R implementation
}
\description{
Get distribution function cdf or pdf name
}
\examples{
pcd_dist_name("lnorm")
pcd_dist_name("lognormal")
pcd_dist_name("gamma")
pcd_dist_name("weibull")
pcd_dist_name("exp")
pcd_dist_name("unif", type = "primary")
pcd_dist_name("expgrowth", type = "primary")
}
\seealso{
Utility functions for working with distributions
\code{\link{add_name_attribute}()},
\code{\link{pcd_distributions}},
\code{\link{pcd_primary_distributions}}
}
\concept{utils}
