% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pressuRe_functions.R
\name{whole_pressure_curve}
\alias{whole_pressure_curve}
\title{Whole pressure curve}
\usage{
whole_pressure_curve(
  pressure_data,
  variable,
  side,
  threshold = 10,
  plot = FALSE
)
}
\arguments{
\item{pressure_data}{List. A 3D array covering each timepoint of the
measurement. z dimension represents time}

\item{variable}{String. "peak_pressure", "force", or "area"}

\item{side}{For insole data only}

\item{threshold}{Numeric. Threshold value for sensor to be considered active.
Currently only applies to insole data}

\item{plot}{Logical. If TRUE also plots data as line curve}
}
\value{
Numeric vector containing variable values
}
\description{
Generates vectors with option to plot for force, peak/mean
pressure and area for complete measurement. Useful for checking data
}
\examples{
emed_data <- system.file("extdata", "emed_test.lst", package = "pressuRe")
pressure_data <- load_emed(emed_data)
whole_pressure_curve(pressure_data, variable = "peak_pressure", plot = FALSE)
whole_pressure_curve(pressure_data, variable = "area", plot = FALSE)
whole_pressure_curve(pressure_data, variable = "force", plot = FALSE)
}
