% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pressuRe_functions.R
\name{plot_pressure}
\alias{plot_pressure}
\title{Plot pressure}
\usage{
plot_pressure(
  pressure_data,
  variable = "max",
  smooth = FALSE,
  frame,
  step_n = "max",
  plot_COP = FALSE,
  plot_outline = FALSE,
  plot_colors = "default",
  break_values,
  break_colors,
  sensor_outline = TRUE,
  plot = TRUE,
  legend = TRUE
)
}
\arguments{
\item{pressure_data}{List. Includes a 3D array covering each timepoint of the
measurement. z dimension represents time}

\item{variable}{String. "max" = footprint of maximum sensors. "mean" =
average value of sensors over time (usually for static analyses). "frame" =
an individual frame}

\item{smooth}{Logical. Not implemented. If TRUE, plot will interpolate
between sensors to increase data density}

\item{frame}{Integer.}

\item{step_n}{If numeric, the step number to plot (only for insole data). If
"max", the max across complete trial, if "meanmax", the max on a per step
basis}

\item{plot_COP}{Logical. If TRUE, overlay COP data on plot. Default = FALSE}

\item{plot_outline}{Logical. If TRUE, overlay convex hull outline on plot}

\item{plot_colors}{String. "default": novel color scheme; "custom": user
supplied}

\item{break_values}{Vector. If plot_colors is "custom", values to split
colors at}

\item{break_colors}{Vector. If plot_colors is "custom", colors to use.
Should be one shorter than break_values}

\item{sensor_outline}{Logical. Sensor outline to be shown}

\item{plot}{Logical. If TRUE, plot will be displayed}

\item{legend}{Logical. If TRUE, legend will be added to plot}
}
\value{
ggplot plot object
}
\description{
Produces visualization of pressure data
}
\examples{
emed_data <- system.file("extdata", "emed_test.lst", package = "pressuRe")
pressure_data <- load_emed(emed_data)
plot_pressure(pressure_data, variable = "max", plot_COP = FALSE)
plot_pressure(pressure_data, variable = "frame", frame = 20,
              plot_colors = "custom", break_values = c(100, 200, 300),
              break_colors = c("light blue", "light green", "yellow", "pink"))
}
