% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/03AnalysisClass.R
\docType{class}
\name{AnalysisClass-class}
\alias{AnalysisClass-class}
\title{An S4 class representing analysis data}
\description{
An S4 class representing analysis data
}
\section{Slots}{

\describe{
\item{\code{objectname}}{(character) Name of the object}

\item{\code{basedata}}{(data frame) A data frame containing the original data}

\item{\code{numericbasedata}}{(data frame) A data frame containing the original data without class labels.}

\item{\code{classlabel}}{(factor) A vector of class labels of the original data}

\item{\code{constructeddata}}{(data frame) Constructed data. Feature vectors from computevalue combined as a data frame}

\item{\code{minmaxconstructeddata}}{(data frame) Min-max normalized constructed data}

\item{\code{combineddata}}{(data frame) Basedata and constructed data combined (note: may include missing values)}

\item{\code{combinednumericdata}}{(data frame) Basedata and constructed data combined without class labels}

\item{\code{longformatmixmaxconstructeddata}}{(data frame) Minmaxconstructeddata in long format}

\item{\code{distancematrix}}{(matrix) Distance matrix of minmaxconstructeddata}

\item{\code{dendogram}}{(dendrogram) Variable clusters (note: not in use)}

\item{\code{lofscores}}{(numeric) A vector of LOF scores}

\item{\code{cmds}}{(data frame) Classical multidimensional scaling two-dimensional data point computed from minmaxconstructeddata}

\item{\code{variableimportancedata}}{(data frame) Constructed features and their random forest variable importance scores for predicting classlabel}

\item{\code{lofsumdata}}{(data frame) mixmax normalized LOF scores of minmaxconstructed data summed with minmax normalized LOF scores of numericbasedata}
}}

