% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inference.R
\name{infer}
\alias{infer}
\title{A function that estimates the user's underlying utility function.}
\usage{
infer(p, estimate = "recommended", nbatch = 1000)
}
\arguments{
\item{p}{A BayesPrefClass instance.}

\item{estimate}{The type of posterior point-estimate returned. Valid options are "recommended" (default), "MAP", and "mean".}

\item{nbatch}{If using Monte Carlo estimates, the number of samples. Defaults to 1000.}
}
\value{
A vector of parameters that best fits the observed preferences.
}
\description{
A function that estimates the user's underlying utility function.
}
\examples{
 p <- prefEl(data = data.frame(c(1,0,1), c(0,1,1), c(1,1,1)),
             priors = c(Normal(0, 1), Exp(0.5), Flat()))
 p$addPref(1 \%>\% 2)
 infer(p, estimate = "recommended")
}
