% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pred.R
\name{pred.compareModels}
\alias{pred.compareModels}
\title{Compare different predictions}
\usage{
pred.compareModels(originalTS, p_1, p_2, p_3 = NULL, p_4 = NULL,
  p_5 = NULL, legendNames = NULL, colors = NULL, legend = TRUE,
  legendPosition = NULL, yAxis = "Values", title = "Predictions")
}
\arguments{
\item{originalTS}{A \code{ts} object}

\item{p_1}{A \code{ts} object}

\item{p_2}{A \code{ts} object}

\item{p_3}{A \code{ts} object. Default is NULL.}

\item{p_4}{A \code{ts} object. Default is NULL.}

\item{p_5}{A \code{ts} object. Default is NULL.}

\item{legendNames}{String vector with the names for the legend. Has to be same length as number of time series we are plotting(including the original one). Default is NULL.}

\item{colors}{Vector with the colors. Has to be same length as number of time series we are plotting(including the original one). Default is NULL.}

\item{legend}{A logical. Do we want a legend? Default is TRUE.}

\item{legendPosition}{A string with the position of the legend (bottomright, topright, ...). Default is NULL.}

\item{yAxis}{A string. Name for the y axis. "Values" as default.}

\item{title}{A string. Title for the plot. Default is "Predictions".}
}
\description{
Plots the original time serie along with 2-5 predictive models.
}
\details{
This function aims to ease the comparation between different predictive models
by plotting them into the same graphic.
}
\examples{
\donttest{
data(AirPassengers)
#pre-processing
p <- prep(AirPassengers)
#modelling
arima.modl <- modl(p)
cart.modl <- modl(p,method='dataMining',algorithm='rpart')
#predicting
arima.pred <- pred(arima.modl,n.ahead=30)
cart.pred <- pred(cart.modl,n.ahead=45)
#post-processing
arima.pred <- postp(arima.pred,p)
cart.pred <- postp(cart.pred,p)
#visual comparison
pred.compareModels(AirPassengers,arima.pred$predictions,cart.pred$predictions
,legendNames=c('AirPassengers','ARIMA','CART'),yAxis='Passengers',legendPosition = 'topleft')
}
}
\author{
Alberto Vico Moreno
}
