#' @description
#' To learn more about how to use predictNMB, see the vignettes at the
#' \href{https://docs.ropensci.org/predictNMB/index.html}{website} or using
#' the following code:
#'
#' `browseVignettes(package = "predictNMB")`
#' @keywords internal
#' @srrstats {G1.0, G1.1} Method to simulate clinical prediction model from
#' AUC - covered by the getting started vignette.
#' @srrstats {G2.0a} Differences between do_nmb_sim() and
#' screen_simulation_inputs() in the getting started vignette.
#' @srrstats {G1.3} All statistical terminology is defined and explained.
#' @srrstats {G1.4, G1.4a} Roxygen is used for all documentation.
#' @srrstats {G1.5, G1.5} No performance claims are made.
#' @srrstats {G2.15} Functions never assume non-missingness.
#' @srrstats {G5.4c} Values used from published paper are used as an example in
#' detailed-example vignette.
#' @srrstats {EA1.3} Each function is documented with expected inputs.
#' Expected use and inputs are also explained in the README and vignettes.
#' @srrstats {EA2.3} All joins are performed on created columns and no assumed
#' column names from inputs. See joins in plot.R and screen_simulation_inputs.R.
#' @srrstats {EA3.0} \code{autoplot()} and \code{summary()} allow for
#' comparisons between inputs at the higher level (simulation inputs
#' combinations level, equivalent of model choice) when used on a
#' 'predictNMBscreen' object. As far as I know, there is no reference
#' implementations for this.
#' @srrstats {EA3.1} \code{autoplot()} and \code{summary()} allow for
#' easy visualisations and aggregations of simulation study data generated by
#' the package to compare between simulation models and cutpoint methods.
#' @srrstats {EA4.2} The two object types, 'predictNMBsim' and
#' 'predictNMBscreen' both include \code{print} and \code{autoplot} methods.
#' Currently, there is no summary method but there is a
#' \code{summary()} method to perform and return aggregations in
#' tabular form.
#'
#'
"_PACKAGE"

## usethis namespace: start
## usethis namespace: end
NULL
