% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv.R
\name{cv}
\alias{cv}
\title{Evaluate Trait Predictability via Cross Validation}
\usage{
cv(fix = NULL, y, kk, nfold = 5, seed = 123)
}
\arguments{
\item{fix}{a design matrix of the fixed effects. If not passed, a vector of ones is added for the intercept.}

\item{y}{a vector of the phenotypic values.}

\item{kk}{a list of one or multiple kinship matrices.}

\item{nfold}{the number of folds. Default is 5.}

\item{seed}{the random number. Default is 123.}
}
\value{
Trait predictability
}
\description{
Evaluate trait predictability of the GBLUP method via k-fold cross validation. For k-fold cross validation, the sample is randomly divided into k equal
sized parts and each part is predicted once using parameters estimated based on the other k – 1 parts. The trait predictability is defined as the squared Pearson correlation coefficient between the observed and the predicted trait values.
}
\examples{
\donttest{
## load example data from hypred package
data(hybrid_phe)
data(input_geno)

## convert original genotype
inbred_gen <- convertgen(input_geno, type = "hmp2")

## infer the additive and dominance genotypes of hybrids
gena <- infergen(inbred_gen, hybrid_phe)$add
gend <- infergen(inbred_gen, hybrid_phe)$dom

## calculate the additive and dominance kinship matrix
ka <- kin(gena)
kd <- kin(gend)

## for the additive model
predictability <- cv(y = hybrid_phe[,3], kk = list(ka))

## for the additive-dominance model
predictability <- cv(y = hybrid_phe[,3], kk = list(ka,kd))
}
}
