% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ps.R
\name{glm.ps}
\alias{glm.ps}
\title{Propensity score estimation with LASSO}
\usage{
glm.ps(trt, x.ps, xnew = NULL, minPS = 0.01, maxPS = 0.99)
}
\arguments{
\item{trt}{Treatment received; vector of size \code{n} (observations) with treatment coded as 0/1}

\item{x.ps}{Matrix of \code{p.ps} baseline covariates (plus a leading column of 1 for the intercept);
dimension \code{n} by \code{p.ps + 1} (covariates in the propensity score model plus intercept)}

\item{xnew}{Matrix of \code{p.ps} baseline covariates (plus a leading column of 1 for the intercept)
for which we want propensity scores predictions; dimension \code{m} (observations in the new data set) by \code{p.ps + 1}}

\item{minPS}{A numerical value (in [0, 1]) below which estimated propensity scores should be
truncated. Default is \code{0.01}.}

\item{maxPS}{A numerical value (in (0, 1]) above which estimated propensity scores should be
truncated. Must be strictly greater than \code{minPS}. Default is \code{0.99}.}
}
\value{
The trimmed propensity score for each unit; vector of size \code{n} (if \code{xnew} is NULL) or \code{m}
}
\description{
Propensity score based on a multivariate logistic regression with LASSO penalization on the two-way interactions
}
